/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.base;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import javax.inject.Named;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourceCoordinator;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.Crawler;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerClient;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.LeaderProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.partition.LeaderPartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.partition.SaasSourcePartition;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.scheduler.LeaderScheduler;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.state.DimensionalTimeSliceLeaderProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.state.DimensionalTimeSliceWorkerProgressState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class DimensionalTimeSliceCrawler
implements Crawler<DimensionalTimeSliceWorkerProgressState> {
    private static final Logger log = LoggerFactory.getLogger(DimensionalTimeSliceCrawler.class);
    protected static final long WAIT_SECONDS_BEFORE_PARTITION_CREATION = 300L;
    private static final String DIMENSIONAL_TIME_SLICE_WORKER_PARTITIONS_CREATED = "dimensionalTimeSliceWorkerPartitionsCreated";
    private static final String WORKER_PARTITION_WAIT_TIME = "workerPartitionWaitTime";
    private static final String WORKER_PARTITION_PROCESS_LATENCY = "workerPartitionProcessLatency";
    private static final Duration HOUR_DURATION = Duration.ofHours(1L);
    private final CrawlerClient client;
    private final Counter partitionsCreatedCounter;
    private final Timer partitionWaitTimeTimer;
    private final Timer partitionProcessLatencyTimer;
    private final AtomicLong localPartitionCounter = new AtomicLong(0L);
    private List<String> dimensionTypes;
    private static final String LAST_UPDATED_KEY = "last_updated|";

    public DimensionalTimeSliceCrawler(CrawlerClient client, PluginMetrics pluginMetrics) {
        this.client = client;
        this.partitionsCreatedCounter = pluginMetrics.counter(DIMENSIONAL_TIME_SLICE_WORKER_PARTITIONS_CREATED);
        this.partitionWaitTimeTimer = pluginMetrics.timer(WORKER_PARTITION_WAIT_TIME);
        this.partitionProcessLatencyTimer = pluginMetrics.timer(WORKER_PARTITION_PROCESS_LATENCY);
    }

    public void initialize(List<String> dimensionTypes) {
        if (this.dimensionTypes != null) {
            throw new IllegalStateException("Crawler already initialized");
        }
        this.dimensionTypes = Objects.requireNonNull(dimensionTypes, "dimensionTypes must not be null");
    }

    @Override
    public Instant crawl(LeaderPartition leaderPartition, EnhancedSourceCoordinator coordinator) {
        long startCount = this.localPartitionCounter.get();
        Instant latestModifiedTime = this.createPartitions(leaderPartition, coordinator);
        long partitionsInThisCrawl = this.localPartitionCounter.get() - startCount;
        log.info("Total partitions created in this crawl: {}", (Object)partitionsInThisCrawl);
        return latestModifiedTime;
    }

    @Override
    public void executePartition(DimensionalTimeSliceWorkerProgressState state, Buffer<Record<Event>> buffer, AcknowledgementSet acknowledgementSet) {
        log.info("Processing partition - DimensionType: {}, TimeRange: {} to {}", new Object[]{state.getDimensionType(), state.getStartTime(), state.getEndTime()});
        this.partitionWaitTimeTimer.record(Duration.between(state.getPartitionCreationTime(), Instant.now()));
        this.partitionProcessLatencyTimer.record(() -> this.client.executePartition(state, buffer, acknowledgementSet));
    }

    private Instant createPartitions(LeaderPartition leaderPartition, EnhancedSourceCoordinator coordinator) {
        DimensionalTimeSliceLeaderProgressState leaderProgressState = (DimensionalTimeSliceLeaderProgressState)leaderPartition.getProgressState().get();
        if (leaderProgressState.getRemainingHours() == 0) {
            return this.createPartitionsForIncrementalSync(leaderPartition, coordinator);
        }
        return this.createPartitionsForHistoricalPull(leaderPartition, coordinator);
    }

    private Instant createPartitionsForHistoricalPull(LeaderPartition leaderPartition, EnhancedSourceCoordinator coordinator) {
        DimensionalTimeSliceLeaderProgressState leaderProgressState = (DimensionalTimeSliceLeaderProgressState)leaderPartition.getProgressState().get();
        int remainingHours = leaderProgressState.getRemainingHours();
        Instant initialTime = leaderProgressState.getLastPollTime();
        Instant latestHour = initialTime.truncatedTo(ChronoUnit.HOURS);
        for (int i = remainingHours; i > 1; --i) {
            Instant startTime = latestHour.minus(Duration.ofHours(i));
            Instant endTime = startTime.plus(HOUR_DURATION);
            this.createWorkerPartitionsForDimensionTypes(startTime, endTime, coordinator);
        }
        Instant latestModifiedTime = initialTime.minusSeconds(300L);
        if (latestModifiedTime.isAfter(latestHour)) {
            this.createWorkerPartitionsForDimensionTypes(latestHour.minus(Duration.ofHours(1L)), latestHour, coordinator);
            this.createWorkerPartitionsForDimensionTypes(latestHour, latestModifiedTime, coordinator);
        } else {
            this.createWorkerPartitionsForDimensionTypes(latestHour.minus(Duration.ofHours(1L)), latestModifiedTime, coordinator);
        }
        this.updateLeaderProgressState(leaderPartition, 0, latestModifiedTime, coordinator);
        return latestModifiedTime;
    }

    private Instant createPartitionsForIncrementalSync(LeaderPartition leaderPartition, EnhancedSourceCoordinator coordinator) {
        Instant latestModifiedTime = Instant.now().minusSeconds(300L);
        LeaderProgressState leaderProgressState = leaderPartition.getProgressState().get();
        Instant lastPollTime = leaderProgressState.getLastPollTime();
        if (lastPollTime.isBefore(latestModifiedTime)) {
            this.createWorkerPartitionsForDimensionTypes(lastPollTime, latestModifiedTime, coordinator);
            this.updateLeaderProgressState(leaderPartition, 0, latestModifiedTime, coordinator);
            return latestModifiedTime;
        }
        return lastPollTime;
    }

    void createWorkerPartitionsForDimensionTypes(Instant startTime, Instant endTime, EnhancedSourceCoordinator coordinator) {
        for (String dimensionType : this.dimensionTypes) {
            DimensionalTimeSliceWorkerProgressState workerState = new DimensionalTimeSliceWorkerProgressState();
            workerState.setPartitionCreationTime(Instant.now());
            workerState.setStartTime(startTime);
            workerState.setEndTime(endTime);
            workerState.setDimensionType(dimensionType);
            SaasSourcePartition partition = new SaasSourcePartition(workerState, LAST_UPDATED_KEY + String.valueOf(UUID.randomUUID()));
            coordinator.createPartition((EnhancedSourcePartition)partition);
            this.partitionsCreatedCounter.increment();
            this.localPartitionCounter.incrementAndGet();
        }
    }

    private void updateLeaderProgressState(LeaderPartition leaderPartition, int remainingHours, Instant updatedPollTime, EnhancedSourceCoordinator coordinator) {
        DimensionalTimeSliceLeaderProgressState state = (DimensionalTimeSliceLeaderProgressState)leaderPartition.getProgressState().get();
        state.setRemainingHours(remainingHours);
        state.setLastPollTime(updatedPollTime);
        leaderPartition.setLeaderProgressState(state);
        coordinator.saveProgressStateForPartition((EnhancedSourcePartition)leaderPartition, LeaderScheduler.DEFAULT_EXTEND_LEASE_MINUTES);
    }
}

