/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.jira;

import io.micrometer.core.instrument.Counter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Named;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.plugins.source.jira.JiraItemInfo;
import org.opensearch.dataprepper.plugins.source.jira.JiraSourceConfig;
import org.opensearch.dataprepper.plugins.source.jira.models.IssueBean;
import org.opensearch.dataprepper.plugins.source.jira.models.SearchResults;
import org.opensearch.dataprepper.plugins.source.jira.rest.JiraRestClient;
import org.opensearch.dataprepper.plugins.source.jira.utils.JiraConfigHelper;
import org.opensearch.dataprepper.plugins.source.source_crawler.model.ItemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Named
public class JiraService {
    private static final Logger log = LoggerFactory.getLogger(JiraService.class);
    public static final String CONTENT_TYPE = "ContentType";
    private static final String SEARCH_RESULTS_FOUND = "searchResultsFound";
    private final JiraSourceConfig jiraSourceConfig;
    private final JiraRestClient jiraRestClient;
    private final Counter searchResultsFoundCounter;

    public JiraService(JiraSourceConfig jiraSourceConfig, JiraRestClient jiraRestClient, PluginMetrics pluginMetrics) {
        this.jiraSourceConfig = jiraSourceConfig;
        this.jiraRestClient = jiraRestClient;
        this.searchResultsFoundCounter = pluginMetrics.counter(SEARCH_RESULTS_FOUND);
    }

    public void getJiraEntities(JiraSourceConfig configuration, Instant timestamp, Queue<ItemInfo> itemInfoQueue) {
        log.trace("Started to fetch entities");
        this.searchForNewTicketsAndAddToQueue(configuration, timestamp, itemInfoQueue);
        log.trace("Creating item information and adding in queue");
    }

    public String getIssue(String issueKey) {
        return this.jiraRestClient.getIssue(issueKey);
    }

    private void searchForNewTicketsAndAddToQueue(JiraSourceConfig configuration, Instant timestamp, Queue<ItemInfo> itemInfoQueue) {
        int total;
        SearchResults searchIssues;
        log.trace("Looking for Add/Modified tickets with a Search API call");
        StringBuilder jql = this.createIssueFilterCriteria(configuration, timestamp);
        int startAt = 0;
        do {
            searchIssues = this.jiraRestClient.getAllIssues(jql, startAt);
            ArrayList<IssueBean> issueList = new ArrayList<IssueBean>(searchIssues.getIssues());
            total = searchIssues.getTotal();
            this.addItemsToQueue(issueList, itemInfoQueue);
        } while ((startAt += searchIssues.getIssues().size()) < total);
        this.searchResultsFoundCounter.increment((double)total);
        log.info("Number of tickets found in search api call: {}", (Object)total);
    }

    private void addItemsToQueue(List<IssueBean> issueList, Queue<ItemInfo> itemInfoQueue) {
        issueList.forEach(issue -> itemInfoQueue.add(JiraItemInfo.builder().withEventTime(Instant.now()).withIssueBean((IssueBean)issue).build()));
    }

    StringBuilder createIssueFilterCriteria(JiraSourceConfig configuration, Instant ts) {
        log.info("Creating issue filter criteria");
        if (!CollectionUtils.isEmpty(JiraConfigHelper.getProjectNameIncludeFilter(configuration)) || !CollectionUtils.isEmpty(JiraConfigHelper.getProjectNameExcludeFilter(configuration))) {
            this.validateProjectFilters(configuration);
        }
        StringBuilder jiraQl = new StringBuilder("updated>" + ts.toEpochMilli());
        if (!CollectionUtils.isEmpty(JiraConfigHelper.getProjectNameIncludeFilter(configuration))) {
            jiraQl.append(" AND project in (").append(JiraConfigHelper.getProjectNameIncludeFilter(configuration).stream().collect(Collectors.joining("\",\"", "\"", "\""))).append(")");
        }
        if (!CollectionUtils.isEmpty(JiraConfigHelper.getProjectNameExcludeFilter(configuration))) {
            jiraQl.append(" AND project not in (").append(JiraConfigHelper.getProjectNameExcludeFilter(configuration).stream().collect(Collectors.joining("\",\"", "\"", "\""))).append(")");
        }
        if (!CollectionUtils.isEmpty(JiraConfigHelper.getIssueTypeIncludeFilter(configuration))) {
            jiraQl.append(" AND issueType in (").append(JiraConfigHelper.getIssueTypeIncludeFilter(configuration).stream().collect(Collectors.joining("\",\"", "\"", "\""))).append(")");
        }
        if (!CollectionUtils.isEmpty(JiraConfigHelper.getIssueTypeExcludeFilter(configuration))) {
            jiraQl.append(" AND issueType not in (").append(JiraConfigHelper.getIssueTypeExcludeFilter(configuration).stream().collect(Collectors.joining("\",\"", "\"", "\""))).append(")");
        }
        if (!CollectionUtils.isEmpty(JiraConfigHelper.getIssueStatusIncludeFilter(configuration))) {
            jiraQl.append(" AND status in (").append(JiraConfigHelper.getIssueStatusIncludeFilter(configuration).stream().collect(Collectors.joining("\",\"", "\"", "\""))).append(")");
        }
        if (!CollectionUtils.isEmpty(JiraConfigHelper.getIssueStatusExcludeFilter(configuration))) {
            jiraQl.append(" AND status not in (").append(JiraConfigHelper.getIssueStatusExcludeFilter(configuration).stream().collect(Collectors.joining("\",\"", "\"", "\""))).append(")");
        }
        jiraQl.append(" order by updated asc ");
        log.info("Created issue filter criteria JiraQl query: {}", (Object)jiraQl);
        return jiraQl;
    }

    private void validateProjectFilters(JiraSourceConfig configuration) {
        log.trace("Validating project filters");
        ArrayList badFilters = new ArrayList();
        HashSet includedProjects = new HashSet();
        ArrayList includedAndExcludedProjects = new ArrayList();
        Pattern regex = Pattern.compile("[^A-Z0-9]");
        JiraConfigHelper.getProjectNameIncludeFilter(configuration).forEach(projectFilter -> {
            Matcher matcher = regex.matcher((CharSequence)projectFilter);
            includedProjects.add(projectFilter);
            if (matcher.find() || projectFilter.length() <= 1 || projectFilter.length() > 100) {
                badFilters.add(projectFilter);
            }
        });
        JiraConfigHelper.getProjectNameExcludeFilter(configuration).forEach(projectFilter -> {
            Matcher matcher = regex.matcher((CharSequence)projectFilter);
            if (includedProjects.contains(projectFilter)) {
                includedAndExcludedProjects.add(projectFilter);
            }
            if (matcher.find() || projectFilter.length() <= 1 || projectFilter.length() > 100) {
                badFilters.add(projectFilter);
            }
        });
        if (!badFilters.isEmpty()) {
            String filters = String.join((CharSequence)("\"" + String.valueOf(badFilters) + "\""), ", ");
            log.error("One or more invalid project keys found in filter configuration: {}", badFilters);
            throw new InvalidPluginConfigurationException("Bad request exception occurred Invalid project key found in filter configuration for " + filters);
        }
        if (!includedAndExcludedProjects.isEmpty()) {
            String filters = String.join((CharSequence)("\"" + String.valueOf(includedAndExcludedProjects) + "\""), ", ");
            log.error("One or more project keys found in both include and exclude: {}", includedAndExcludedProjects);
            throw new InvalidPluginConfigurationException("Bad request exception occurred Project filters is invalid because the following projects are listed in both include and exclude" + filters);
        }
    }
}

