/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source;

import com.google.common.base.Preconditions;
import java.util.Scanner;
import java.util.concurrent.TimeoutException;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.source.StdInSourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="stdin", pluginType=Source.class, pluginConfigurationType=StdInSourceConfig.class)
public class StdInSource
implements Source<Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(StdInSource.class);
    private static final String ATTRIBUTE_TIMEOUT = "write_timeout";
    private static final int WRITE_TIMEOUT = 5000;
    private final Scanner reader;
    private final int writeTimeout;
    private final String pipelineName;
    private boolean isStopRequested;

    @DataPrepperPluginConstructor
    public StdInSource(StdInSourceConfig stdInSourceConfig, PipelineDescription pipelineDescription) {
        this(((StdInSourceConfig)Preconditions.checkNotNull((Object)stdInSourceConfig, (Object)"StdInSourceConfig cannot be null")).getWriteTimeout(), pipelineDescription.getPipelineName());
    }

    public StdInSource(int writeTimeout, String pipelineName) {
        this.writeTimeout = writeTimeout;
        this.pipelineName = (String)Preconditions.checkNotNull((Object)pipelineName, (Object)"Pipeline name cannot be null");
        this.reader = new Scanner(System.in);
        this.isStopRequested = false;
    }

    public void start(Buffer<Record<Event>> buffer) {
        Preconditions.checkNotNull(buffer, (Object)String.format("Pipeline [%s] - buffer cannot be null for source to start", this.pipelineName));
        String line = this.reader.nextLine();
        while (!"exit".equalsIgnoreCase(line) && !this.isStopRequested) {
            Record<Event> record = this.convertLineIntoEventRecord(line);
            try {
                buffer.write(record, this.writeTimeout);
            }
            catch (TimeoutException ex) {
                LOG.error("Pipeline [{}] - Timed out writing to buffer; Will exit without further processing", (Object)this.pipelineName, (Object)ex);
                throw new RuntimeException(String.format("Pipeline [%s] - Timed out writing to buffer", this.pipelineName), ex);
            }
            line = this.reader.nextLine();
        }
    }

    public void stop() {
        this.isStopRequested = true;
    }

    private Record<Event> convertLineIntoEventRecord(String line) {
        Event event = JacksonEvent.fromMessage((String)line);
        return new Record((Object)event);
    }
}

