/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.accumulator;

import java.io.File;
import java.io.IOException;
import org.opensearch.dataprepper.plugins.accumulator.Buffer;
import org.opensearch.dataprepper.plugins.accumulator.BufferFactory;
import org.opensearch.dataprepper.plugins.accumulator.LocalFileBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalFileBufferFactory
implements BufferFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileBufferFactory.class);
    public static final String PREFIX = "local";
    public static final String SUFFIX = ".log";

    @Override
    public Buffer getBuffer() {
        File tempFile = null;
        LocalFileBuffer localfileBuffer = null;
        try {
            tempFile = File.createTempFile(PREFIX, SUFFIX);
            localfileBuffer = new LocalFileBuffer(tempFile);
        }
        catch (IOException e) {
            LOG.error("Unable to create temp file ", (Throwable)e);
        }
        return localfileBuffer;
    }
}

