/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.BasicAuthenticator;
import java.util.Objects;
import org.opensearch.dataprepper.core.pipeline.server.DataPrepperCoreAuthenticationProvider;
import org.opensearch.dataprepper.core.pipeline.server.HttpBasicAuthenticationConfig;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;

@DataPrepperPlugin(name="http_basic", pluginType=DataPrepperCoreAuthenticationProvider.class, pluginConfigurationType=HttpBasicAuthenticationConfig.class)
public class HttpBasicDataPrepperCoreAuthenticationProvider
implements DataPrepperCoreAuthenticationProvider {
    private final HttpBasicAuthenticationConfig httpBasicAuthenticationConfig;
    private final CoreAuthenticator coreAuthenticator;

    @DataPrepperPluginConstructor
    public HttpBasicDataPrepperCoreAuthenticationProvider(HttpBasicAuthenticationConfig httpBasicAuthenticationConfig) {
        this.httpBasicAuthenticationConfig = httpBasicAuthenticationConfig;
        Objects.requireNonNull(this.httpBasicAuthenticationConfig);
        Objects.requireNonNull(httpBasicAuthenticationConfig.getUsername());
        Objects.requireNonNull(httpBasicAuthenticationConfig.getPassword());
        this.coreAuthenticator = new CoreAuthenticator();
    }

    @Override
    public Authenticator getAuthenticator() {
        return this.coreAuthenticator;
    }

    private class CoreAuthenticator
    extends BasicAuthenticator {
        CoreAuthenticator() {
            super("core");
        }

        @Override
        public boolean checkCredentials(String username, String password) {
            return HttpBasicDataPrepperCoreAuthenticationProvider.this.httpBasicAuthenticationConfig.getUsername().equals(username) && HttpBasicDataPrepperCoreAuthenticationProvider.this.httpBasicAuthenticationConfig.getPassword().equals(password);
        }
    }
}

