/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.opensearch.dataprepper.DataPrepperShutdownOptions;
import org.opensearch.dataprepper.core.DataPrepper;
import org.opensearch.dataprepper.pipeline.parser.DataPrepperDurationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHandler
implements HttpHandler {
    private final DataPrepper dataPrepper;
    private static final Logger LOG = LoggerFactory.getLogger(ShutdownHandler.class);

    public ShutdownHandler(DataPrepper dataPrepper) {
        this.dataPrepper = dataPrepper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange exchange) throws IOException {
        String requestMethod = exchange.getRequestMethod();
        if (!requestMethod.equals("POST")) {
            exchange.sendResponseHeaders(405, 0L);
            exchange.getResponseBody().close();
            return;
        }
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Received HTTP shutdown request to shutdown Data Prepper. Shutdown pipelines and server. User-Agent='{}'", (Object)exchange.getRequestHeaders().getFirst("User-Agent"));
            }
            DataPrepperShutdownOptions dataPrepperShutdownOptions = this.mapShutdownOptions(exchange.getRequestURI());
            this.dataPrepper.shutdownPipelines(dataPrepperShutdownOptions);
            exchange.sendResponseHeaders(200, 0L);
        }
        catch (Exception e) {
            LOG.error("Caught exception shutting down data prepper", (Throwable)e);
            exchange.sendResponseHeaders(500, 0L);
        }
        finally {
            exchange.getResponseBody().close();
            this.dataPrepper.shutdownServers();
        }
    }

    private DataPrepperShutdownOptions mapShutdownOptions(URI requestURI) {
        List queryParams = URLEncodedUtils.parse((URI)requestURI, (Charset)Charset.defaultCharset());
        DataPrepperShutdownOptions.Builder shutdownOptionsBuilder = DataPrepperShutdownOptions.builder();
        block8: for (NameValuePair queryParam : queryParams) {
            String value = queryParam.getValue();
            switch (queryParam.getName()) {
                case "bufferReadTimeout": {
                    shutdownOptionsBuilder = shutdownOptionsBuilder.withBufferReadTimeout(DataPrepperDurationParser.parse((String)value));
                    continue block8;
                }
                case "bufferDrainTimeout": {
                    shutdownOptionsBuilder = shutdownOptionsBuilder.withBufferDrainTimeout(DataPrepperDurationParser.parse((String)value));
                    continue block8;
                }
            }
            LOG.warn("Unrecognized query parameter '{}'", (Object)queryParam.getName());
        }
        return shutdownOptionsBuilder.build();
    }
}

