/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.dataprepper.core.peerforwarder.ForwardingAuthentication;
import org.opensearch.dataprepper.core.peerforwarder.discovery.DiscoveryMode;

public class PeerForwarderConfiguration {
    public static final String DEFAULT_PEER_FORWARDING_URI = "/event/forward";
    public static final Duration DEFAULT_DRAIN_TIMEOUT = Duration.ofSeconds(10L);
    public static final Duration DEFAULT_FORWARDING_BATCH_TIMEOUT = Duration.ofSeconds(3L);
    public static final String DEFAULT_CERTIFICATE_FILE_PATH = "config/default_certificate.pem";
    public static final String DEFAULT_PRIVATE_KEY_FILE_PATH = "config/default_private_key.pem";
    private static final String S3_PREFIX = "s3://";
    public static final int MAX_FORWARDING_BATCH_SIZE = 15000;
    private Integer serverPort = 4994;
    private Integer requestTimeout = 10000;
    private Integer clientTimeout = 60000;
    private Integer serverThreadCount = 200;
    private Integer maxConnectionCount = 500;
    private Integer maxPendingRequests = 1024;
    private boolean ssl = true;
    private String sslCertificateFile = "config/default_certificate.pem";
    private String sslKeyFile = "config/default_private_key.pem";
    private boolean sslDisableVerification = false;
    private boolean sslFingerprintVerificationOnly = false;
    private ForwardingAuthentication authentication = ForwardingAuthentication.UNAUTHENTICATED;
    private boolean useAcmCertificateForSsl = false;
    private String acmCertificateArn;
    private String acmPrivateKeyPassword;
    private Integer acmCertificateTimeoutMillis = 120000;
    private DiscoveryMode discoveryMode = DiscoveryMode.LOCAL_NODE;
    private String awsCloudMapNamespaceName;
    private String awsCloudMapServiceName;
    private String awsRegion;
    private Map<String, String> awsCloudMapQueryParameters = Collections.emptyMap();
    private String domainName;
    private List<String> staticEndpoints = new ArrayList<String>();
    private Integer clientThreadCount = 200;
    private Integer batchSize = 48;
    private Integer batchDelay = 3000;
    private Integer bufferSize = 512;
    private boolean sslCertAndKeyFileInS3 = false;
    private Duration drainTimeout = DEFAULT_DRAIN_TIMEOUT;
    private Integer failedForwardingRequestLocalWriteTimeout = 500;
    private Integer forwardingBatchSize = 1500;
    private Integer forwardingBatchQueueDepth = 1;
    private Duration forwardingBatchTimeout = DEFAULT_FORWARDING_BATCH_TIMEOUT;
    private boolean binaryCodec = true;
    private List<Set<String>> excludeIdentificationKeys;

    public PeerForwarderConfiguration() {
    }

    @JsonCreator
    public PeerForwarderConfiguration(@JsonProperty(value="port") Integer serverPort, @JsonProperty(value="request_timeout") Integer requestTimeout, @JsonProperty(value="client_timeout") Integer clientTimeout, @JsonProperty(value="server_thread_count") Integer serverThreadCount, @JsonProperty(value="max_connection_count") Integer maxConnectionCount, @JsonProperty(value="max_pending_requests") Integer maxPendingRequests, @JsonProperty(value="exclude_identification_keys") List<Set<String>> excludeIdentificationKeys, @JsonProperty(value="ssl") Boolean ssl, @JsonProperty(value="ssl_certificate_file") String sslCertificateFile, @JsonProperty(value="ssl_key_file") String sslKeyFile, @JsonProperty(value="ssl_insecure_disable_verification") boolean sslDisableVerification, @JsonProperty(value="ssl_fingerprint_verification_only") boolean sslFingerprintVerificationOnly, @JsonProperty(value="authentication") Map<String, Object> authentication, @JsonProperty(value="use_acm_certificate_for_ssl") Boolean useAcmCertificateForSsl, @JsonProperty(value="acm_certificate_arn") String acmCertificateArn, @JsonProperty(value="acm_private_key_password") String acmPrivateKeyPassword, @JsonProperty(value="acm_certificate_timeout_millis") Integer acmCertificateTimeoutMillis, @JsonProperty(value="discovery_mode") String discoveryMode, @JsonProperty(value="aws_cloud_map_namespace_name") String awsCloudMapNamespaceName, @JsonProperty(value="aws_cloud_map_service_name") String awsCloudMapServiceName, @JsonProperty(value="aws_region") String awsRegion, @JsonProperty(value="aws_cloud_map_query_parameters") Map<String, String> awsCloudMapQueryParameters, @JsonProperty(value="domain_name") String domainName, @JsonProperty(value="static_endpoints") List<String> staticEndpoints, @JsonProperty(value="client_thread_count") Integer clientThreadCount, @JsonProperty(value="batch_size") Integer batchSize, @JsonProperty(value="batch_delay") Integer batchDelay, @JsonProperty(value="buffer_size") Integer bufferSize, @JsonProperty(value="drain_timeout") Duration drainTimeout, @JsonProperty(value="failed_forwarding_requests_local_write_timeout") Integer failedForwardingRequestLocalWriteTimeout, @JsonProperty(value="forwarding_batch_size") Integer forwardingBatchSize, @JsonProperty(value="forwarding_batch_queue_depth") Integer forwardingBatchQueueDepth, @JsonProperty(value="forwarding_batch_timeout") Duration forwardingBatchTimeout, @JsonProperty(value="binary_codec") Boolean binaryCodec) {
        this.setServerPort(serverPort);
        this.setRequestTimeout(requestTimeout);
        this.setClientTimeout(clientTimeout);
        this.setServerThreadCount(serverThreadCount);
        this.setMaxConnectionCount(maxConnectionCount);
        this.setMaxPendingRequests(maxPendingRequests);
        this.setSsl(ssl);
        this.setUseAcmCertificateForSsl(useAcmCertificateForSsl);
        this.setSslCertificateFile(sslCertificateFile);
        this.setSslKeyFile(sslKeyFile);
        this.setDisableVerification(sslDisableVerification);
        this.setFingerprintVerificationOnly(sslFingerprintVerificationOnly);
        this.setAuthentication(authentication);
        this.setAcmCertificateArn(acmCertificateArn);
        this.acmPrivateKeyPassword = acmPrivateKeyPassword;
        this.setAcmCertificateTimeoutMillis(acmCertificateTimeoutMillis);
        this.setDiscoveryMode(discoveryMode);
        this.setAwsCloudMapNamespaceName(awsCloudMapNamespaceName);
        this.setAwsCloudMapServiceName(awsCloudMapServiceName);
        this.setAwsRegion(awsRegion);
        this.setAwsCloudMapQueryParameters(awsCloudMapQueryParameters);
        this.setDomainName(domainName);
        this.setStaticEndpoints(staticEndpoints);
        this.setClientThreadCount(clientThreadCount);
        this.setBatchSize(batchSize);
        this.setBatchDelay(batchDelay);
        this.setBufferSize(bufferSize);
        this.setDrainTimeout(drainTimeout);
        this.setFailedForwardingRequestLocalWriteTimeout(failedForwardingRequestLocalWriteTimeout);
        this.setForwardingBatchSize(forwardingBatchSize);
        this.setForwardingBatchQueueDepth(forwardingBatchQueueDepth);
        this.setForwardingBatchTimeout(forwardingBatchTimeout);
        this.setBinaryCodec(binaryCodec == null || binaryCodec != false);
        this.checkForCertAndKeyFileInS3();
        this.validateSslAndAuthentication();
        this.excludeIdentificationKeys = excludeIdentificationKeys;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public int getRequestTimeout() {
        return this.requestTimeout;
    }

    public int getClientTimeout() {
        return this.clientTimeout;
    }

    public int getServerThreadCount() {
        return this.serverThreadCount;
    }

    public int getMaxConnectionCount() {
        return this.maxConnectionCount;
    }

    public int getMaxPendingRequests() {
        return this.maxPendingRequests;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public Set<Set<String>> getExcludeIdentificationKeys() {
        if (this.excludeIdentificationKeys == null) {
            return null;
        }
        return this.excludeIdentificationKeys.stream().collect(Collectors.toSet());
    }

    public String getSslCertificateFile() {
        return this.sslCertificateFile;
    }

    public String getSslKeyFile() {
        return this.sslKeyFile;
    }

    public boolean isUseAcmCertificateForSsl() {
        return this.useAcmCertificateForSsl;
    }

    public String getAcmCertificateArn() {
        return this.acmCertificateArn;
    }

    public String getAcmPrivateKeyPassword() {
        return this.acmPrivateKeyPassword;
    }

    public int getAcmCertificateTimeoutMillis() {
        return this.acmCertificateTimeoutMillis;
    }

    public DiscoveryMode getDiscoveryMode() {
        return this.discoveryMode;
    }

    public String getAwsCloudMapNamespaceName() {
        return this.awsCloudMapNamespaceName;
    }

    public String getAwsCloudMapServiceName() {
        return this.awsCloudMapServiceName;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public Map<String, String> getAwsCloudMapQueryParameters() {
        return this.awsCloudMapQueryParameters;
    }

    public List<String> getStaticEndpoints() {
        return this.staticEndpoints;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public Integer getClientThreadCount() {
        return this.clientThreadCount;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public Integer getBatchDelay() {
        return this.batchDelay;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Duration getDrainTimeout() {
        return this.drainTimeout;
    }

    public Integer getFailedForwardingRequestLocalWriteTimeout() {
        return this.failedForwardingRequestLocalWriteTimeout;
    }

    public Integer getForwardingBatchSize() {
        return this.forwardingBatchSize;
    }

    public Integer getForwardingBatchQueueDepth() {
        return this.forwardingBatchQueueDepth;
    }

    public Duration getForwardingBatchTimeout() {
        return this.forwardingBatchTimeout;
    }

    public boolean getBinaryCodec() {
        return this.binaryCodec;
    }

    private void setServerPort(Integer serverPort) {
        if (serverPort != null) {
            if (serverPort < 0 || serverPort > 65535) {
                throw new IllegalArgumentException("Server port should be between 0 and 65535.");
            }
            this.serverPort = serverPort;
        }
    }

    private void setRequestTimeout(Integer requestTimeout) {
        if (requestTimeout != null) {
            if (requestTimeout <= 1) {
                throw new IllegalArgumentException("Request timeout must be a positive integer greater than 1.");
            }
            this.requestTimeout = requestTimeout;
        }
    }

    private void setClientTimeout(Integer clientTimeout) {
        if (clientTimeout != null) {
            if (clientTimeout <= 0) {
                throw new IllegalArgumentException("Client timeout must be a positive integer.");
            }
            this.clientTimeout = clientTimeout;
        }
    }

    private void setServerThreadCount(Integer serverThreadCount) {
        if (serverThreadCount != null) {
            if (serverThreadCount <= 0) {
                throw new IllegalArgumentException("Server thread count must be a positive integer.");
            }
            this.serverThreadCount = serverThreadCount;
        }
    }

    private void setMaxConnectionCount(Integer maxConnectionCount) {
        if (maxConnectionCount != null) {
            if (maxConnectionCount <= 0) {
                throw new IllegalArgumentException("Maximum connection count must be a positive integer.");
            }
            this.maxConnectionCount = maxConnectionCount;
        }
    }

    private void setMaxPendingRequests(Integer maxPendingRequests) {
        if (maxPendingRequests != null) {
            if (maxPendingRequests <= 0) {
                throw new IllegalArgumentException("Maximum pending requests must be a positive integer.");
            }
            this.maxPendingRequests = maxPendingRequests;
        }
    }

    private void setSsl(Boolean ssl) {
        if (ssl != null) {
            this.ssl = ssl;
        }
    }

    private void setSslCertificateFile(String sslCertificateFile) {
        if (this.ssl && !this.useAcmCertificateForSsl && sslCertificateFile != null) {
            this.sslCertificateFile = sslCertificateFile;
        }
    }

    private void setSslKeyFile(String sslKeyFile) {
        if (this.ssl && !this.useAcmCertificateForSsl && sslKeyFile != null) {
            this.sslKeyFile = sslKeyFile;
        }
    }

    private void setDisableVerification(boolean sslDisableVerification) {
        this.sslDisableVerification = sslDisableVerification;
    }

    public boolean isSslDisableVerification() {
        return this.sslDisableVerification;
    }

    private void setFingerprintVerificationOnly(boolean sslFingerprintVerificationOnly) {
        this.sslFingerprintVerificationOnly = sslFingerprintVerificationOnly;
    }

    public boolean isSslFingerprintVerificationOnly() {
        return this.sslFingerprintVerificationOnly;
    }

    private void setAuthentication(Map<String, Object> authentication) {
        if (authentication == null) {
            return;
        }
        if (authentication.isEmpty()) {
            return;
        }
        if (authentication.size() > 1) {
            throw new IllegalArgumentException("Invalid authentication configuration.");
        }
        String authenticationName = authentication.keySet().iterator().next();
        this.authentication = ForwardingAuthentication.getByName(authenticationName);
    }

    public ForwardingAuthentication getAuthentication() {
        return this.authentication;
    }

    private void setUseAcmCertificateForSsl(Boolean useAcmCertificateForSsl) {
        if (useAcmCertificateForSsl != null) {
            this.useAcmCertificateForSsl = useAcmCertificateForSsl;
        }
    }

    private void setAcmCertificateArn(String acmCertificateArn) {
        if (this.useAcmCertificateForSsl && !StringUtils.isNotEmpty((CharSequence)acmCertificateArn)) {
            throw new IllegalArgumentException("ACM certificate ARN cannot be empty if ACM certificate is ued for SSL.");
        }
        this.acmCertificateArn = acmCertificateArn;
    }

    private void setAcmCertificateTimeoutMillis(Integer acmCertificateTimeoutMillis) {
        if (acmCertificateTimeoutMillis != null) {
            if (acmCertificateTimeoutMillis <= 0) {
                throw new IllegalArgumentException("ACM certificate timeout must be a positive integer");
            }
            this.acmCertificateTimeoutMillis = acmCertificateTimeoutMillis;
        }
    }

    private void setDiscoveryMode(String discoveryMode) {
        if (discoveryMode != null) {
            this.discoveryMode = DiscoveryMode.valueOf(discoveryMode.toUpperCase());
        }
    }

    private void setAwsCloudMapNamespaceName(String awsCloudMapNamespaceName) {
        if (this.discoveryMode.equals((Object)DiscoveryMode.AWS_CLOUD_MAP)) {
            if (awsCloudMapNamespaceName != null) {
                this.awsCloudMapNamespaceName = awsCloudMapNamespaceName;
            } else {
                throw new IllegalArgumentException("Cloud Map namespace cannot be null if discover mode is AWS Cloud Map.");
            }
        }
    }

    private void setAwsCloudMapServiceName(String awsCloudMapServiceName) {
        if (this.discoveryMode.equals((Object)DiscoveryMode.AWS_CLOUD_MAP)) {
            if (awsCloudMapServiceName != null) {
                this.awsCloudMapServiceName = awsCloudMapServiceName;
            } else {
                throw new IllegalArgumentException("Cloud Map service name cannot be null if discover mode is AWS Cloud Map.");
            }
        }
    }

    private void setAwsRegion(String awsRegion) {
        if (this.discoveryMode.equals((Object)DiscoveryMode.AWS_CLOUD_MAP) || this.useAcmCertificateForSsl) {
            if (StringUtils.isNotEmpty((CharSequence)awsRegion)) {
                this.awsRegion = awsRegion;
            } else {
                throw new IllegalArgumentException("AWS region cannot be null if discover mode is AWS Cloud Map or if ACM certificate for SLL is enabled.");
            }
        }
    }

    private void setAwsCloudMapQueryParameters(Map<String, String> awsCloudMapQueryParameters) {
        if (awsCloudMapQueryParameters != null) {
            this.awsCloudMapQueryParameters = awsCloudMapQueryParameters;
        }
    }

    private void setDomainName(String domainName) {
        if (this.discoveryMode.equals((Object)DiscoveryMode.DNS)) {
            if (domainName != null) {
                this.domainName = domainName;
            } else {
                throw new IllegalArgumentException("Domain name cannot be null if discover mode is DNS.");
            }
        }
    }

    private void setStaticEndpoints(List<String> staticEndpoints) {
        if (staticEndpoints != null) {
            this.staticEndpoints = staticEndpoints;
        }
    }

    public void setClientThreadCount(Integer clientThreadCount) {
        if (clientThreadCount != null) {
            if (clientThreadCount <= 0) {
                throw new IllegalArgumentException("Client thread count must be a positive integer.");
            }
            this.clientThreadCount = clientThreadCount;
        }
    }

    private void setBatchSize(Integer batchSize) {
        if (batchSize != null) {
            if (batchSize <= 0) {
                throw new IllegalArgumentException("Batch size must be a positive integer.");
            }
            this.batchSize = batchSize;
        }
    }

    private void setBatchDelay(Integer batchDelay) {
        if (batchDelay != null) {
            if (batchDelay < 0) {
                throw new IllegalArgumentException("Batch delay must be a non-negative integer.");
            }
            this.batchDelay = batchDelay;
        }
    }

    private void setBufferSize(Integer bufferSize) {
        if (bufferSize != null) {
            if (bufferSize <= 0) {
                throw new IllegalArgumentException("Buffer size must be a positive integer.");
            }
            this.bufferSize = bufferSize;
        }
    }

    private void checkForCertAndKeyFileInS3() {
        if (this.ssl && !this.useAcmCertificateForSsl && this.sslCertificateFile.toLowerCase().startsWith(S3_PREFIX) && this.sslKeyFile.toLowerCase().startsWith(S3_PREFIX)) {
            this.sslCertAndKeyFileInS3 = true;
        }
    }

    public boolean isSslCertAndKeyFileInS3() {
        return this.sslCertAndKeyFileInS3;
    }

    private void validateSslAndAuthentication() {
        if (this.authentication == ForwardingAuthentication.MUTUAL_TLS && !this.ssl) {
            throw new IllegalArgumentException("Mutual TLS is only available when SSL is enabled.");
        }
    }

    private void setDrainTimeout(Duration drainTimeout) {
        if (drainTimeout != null) {
            if (drainTimeout.isNegative()) {
                throw new IllegalArgumentException("Peer forwarder drain timeout must be non-negative.");
            }
            this.drainTimeout = drainTimeout;
        }
    }

    private void setFailedForwardingRequestLocalWriteTimeout(Integer failedForwardingRequestLocalWriteTimeout) {
        if (failedForwardingRequestLocalWriteTimeout != null) {
            if (failedForwardingRequestLocalWriteTimeout <= 0) {
                throw new IllegalArgumentException("Failed forwarding requests local write timeout must be a positive integer.");
            }
            this.failedForwardingRequestLocalWriteTimeout = failedForwardingRequestLocalWriteTimeout;
        }
    }

    private void setForwardingBatchSize(Integer forwardingBatchSize) {
        if (forwardingBatchSize != null) {
            if (forwardingBatchSize <= 0 || forwardingBatchSize > 15000) {
                throw new IllegalArgumentException("Forwarding batch size must be between 1 and 3000 inclusive.");
            }
            this.forwardingBatchSize = forwardingBatchSize;
        }
    }

    private void setForwardingBatchQueueDepth(Integer forwardingBatchQueueDepth) {
        if (forwardingBatchQueueDepth != null) {
            if (forwardingBatchQueueDepth <= 0) {
                throw new IllegalArgumentException("Forwarding batch queue depth must be a positive integer.");
            }
            this.forwardingBatchQueueDepth = forwardingBatchQueueDepth;
        }
    }

    private void setForwardingBatchTimeout(Duration forwardingBatchTimeout) {
        if (forwardingBatchTimeout != null) {
            if (forwardingBatchTimeout.isNegative()) {
                throw new IllegalArgumentException("Forwarding batch timeout must be non-negative.");
            }
            this.forwardingBatchTimeout = forwardingBatchTimeout;
        }
    }

    private void setBinaryCodec(boolean binaryCodec) {
        this.binaryCodec = binaryCodec;
    }
}

