/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.processor;

import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.codec.InputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.plugins.lambda.common.LambdaCommonHandler;
import org.opensearch.dataprepper.plugins.lambda.common.accumlator.Buffer;
import org.opensearch.dataprepper.plugins.lambda.processor.LambdaInvoker;
import org.opensearch.dataprepper.plugins.lambda.processor.LambdaProcessor;
import org.opensearch.dataprepper.plugins.lambda.processor.LambdaProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.model.InvokeResponse;
import software.amazon.awssdk.services.lambda.model.LambdaException;
import software.amazon.awssdk.services.lambda.model.ResourceNotFoundException;

public class SyncLambdaInvoker
implements LambdaInvoker {
    private static final Logger LOG = LoggerFactory.getLogger(SyncLambdaInvoker.class);
    private static final String EXCEEDING_PAYLOAD_LIMIT_EXCEPTION = "Status Code: 413";
    private final LambdaProcessor processor;

    public SyncLambdaInvoker(LambdaProcessorConfig lambdaProcessorConfig, LambdaAsyncClient lambdaAsyncClient, InputCodec responseCodec, LambdaProcessor processor) {
        this.processor = processor;
    }

    @Override
    public Collection<Record<Event>> invoke(List<Record<Event>> recordsToLambda, List<Record<Event>> resultRecords) {
        Map<Object, Object> bufferToFutureMap = new HashMap();
        try {
            bufferToFutureMap = LambdaCommonHandler.sendRecords(recordsToLambda, this.processor.lambdaProcessorConfig, this.processor.lambdaAsyncClient, new OutputCodecContext());
        }
        catch (Exception e) {
            LOG.error(DataPrepperMarkers.NOISY, "Error while batching and sending records to Lambda", (Throwable)e);
            this.processor.numberOfRecordsFailedCounter.increment((double)recordsToLambda.size());
            this.processor.numberOfRequestsFailedCounter.increment();
            resultRecords.addAll(this.processor.addFailureTags(recordsToLambda));
        }
        for (Map.Entry<Object, Object> entry : bufferToFutureMap.entrySet()) {
            CompletableFuture future = (CompletableFuture)entry.getValue();
            Buffer inputBuffer = (Buffer)entry.getKey();
            try {
                InvokeResponse response = (InvokeResponse)future.join();
                Duration latency = inputBuffer.stopLatencyWatch();
                this.processor.lambdaLatencyMetric.record(latency.toMillis(), TimeUnit.MILLISECONDS);
                this.processor.requestPayloadMetric.record((double)inputBuffer.getPayloadRequestSize().longValue());
                if (!LambdaCommonHandler.isSuccess(response)) {
                    String errorMessage = String.format("Lambda invoke failed with status code %s error %s ", response.statusCode(), response.payload().asUtf8String());
                    throw new RuntimeException(errorMessage);
                }
                resultRecords.addAll(this.processor.convertLambdaResponseToEvent(inputBuffer, response));
                this.processor.numberOfRecordsSuccessCounter.increment((double)inputBuffer.getEventCount());
                this.processor.numberOfRequestsSuccessCounter.increment();
                if (response.payload() == null) continue;
                this.processor.responsePayloadMetric.record((double)response.payload().asByteArray().length);
            }
            catch (ResourceNotFoundException e) {
                LOG.error(DataPrepperMarkers.NOISY, "Lambda function not found: {}", (Object)e.getMessage());
                this.processor.numberOfRecordsFailedCounter.increment((double)inputBuffer.getEventCount());
                this.processor.numberOfRequestsFailedCounter.increment();
                resultRecords.addAll(this.processor.addFailureTags(inputBuffer.getRecords()));
            }
            catch (LambdaException e) {
                LOG.error(DataPrepperMarkers.NOISY, "Lambda invocation failed: {}", (Object)e.getMessage());
                if (e.getMessage() != null && e.getMessage().contains(EXCEEDING_PAYLOAD_LIMIT_EXCEPTION)) {
                    this.processor.batchExceedingThresholdCounter.increment();
                }
                this.processor.numberOfRecordsFailedCounter.increment((double)inputBuffer.getEventCount());
                this.processor.numberOfRequestsFailedCounter.increment();
                resultRecords.addAll(this.processor.addFailureTags(inputBuffer.getRecords()));
            }
            catch (AwsServiceException e) {
                LOG.error(DataPrepperMarkers.NOISY, "AWS service error during Lambda invocation: {}", (Object)e.getMessage());
                this.processor.numberOfRecordsFailedCounter.increment((double)inputBuffer.getEventCount());
                this.processor.numberOfRequestsFailedCounter.increment();
                resultRecords.addAll(this.processor.addFailureTags(inputBuffer.getRecords()));
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.NOISY, "Unexpected error processing Lambda response.", (Throwable)e);
                this.processor.numberOfRecordsFailedCounter.increment((double)inputBuffer.getEventCount());
                this.processor.numberOfRequestsFailedCounter.increment();
                resultRecords.addAll(this.processor.addFailureTags(inputBuffer.getRecords()));
            }
        }
        return resultRecords;
    }
}

