/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.pipeline.parser.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.configuration.ConditionalRoute;
import org.opensearch.dataprepper.model.configuration.PipelineModel;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.configuration.SinkModel;
import org.opensearch.dataprepper.model.sink.SinkContext;
import org.opensearch.dataprepper.pipeline.parser.model.SinkContextPluginSetting;
import org.opensearch.dataprepper.plugins.buffer.blockingbuffer.BlockingBuffer;

public class PipelineConfiguration {
    private static final String WORKERS_COMPONENT = "workers";
    private static final String DELAY_COMPONENT = "delay";
    private static final int DEFAULT_READ_BATCH_DELAY = 3000;
    private static final int DEFAULT_WORKERS = 1;
    private final PluginSetting sourcePluginSetting;
    private final PluginSetting bufferPluginSetting;
    private final List<PluginSetting> processorPluginSettings;
    private final List<SinkContextPluginSetting> sinkPluginSettings;
    private final Integer workers;
    private final Integer readBatchDelay;
    private final Set<ConditionalRoute> routes;

    public PipelineConfiguration(PipelineModel pipelineModel) {
        this.sourcePluginSetting = this.getSourceFromPluginModel(pipelineModel.getSource());
        this.bufferPluginSetting = this.getBufferFromPluginModelOrDefault(pipelineModel.getBuffer());
        this.processorPluginSettings = this.getProcessorsFromPluginModel(pipelineModel.getProcessors());
        this.sinkPluginSettings = this.getSinksFromPluginModel(pipelineModel.getSinks());
        this.workers = this.getWorkersFromPipelineModel(pipelineModel);
        this.readBatchDelay = this.getReadBatchDelayFromPipelineModel(pipelineModel);
        this.routes = new HashSet<ConditionalRoute>(pipelineModel.getRoutes());
    }

    public PluginSetting getSourcePluginSetting() {
        return this.sourcePluginSetting;
    }

    public PluginSetting getBufferPluginSetting() {
        return this.bufferPluginSetting;
    }

    public List<PluginSetting> getProcessorPluginSettings() {
        return this.processorPluginSettings;
    }

    public List<SinkContextPluginSetting> getSinkPluginSettings() {
        return this.sinkPluginSettings;
    }

    public Set<ConditionalRoute> getRoutes() {
        return this.routes;
    }

    public Integer getWorkers() {
        return this.workers;
    }

    public Integer getReadBatchDelay() {
        return this.readBatchDelay;
    }

    public void updateCommonPipelineConfiguration(String pipelineName) {
        if (this.sourcePluginSetting != null) {
            this.updatePluginSetting(this.sourcePluginSetting, pipelineName);
        }
        this.updatePluginSetting(this.bufferPluginSetting, pipelineName);
        this.processorPluginSettings.forEach(processorPluginSettings -> this.updatePluginSetting((PluginSetting)processorPluginSettings, pipelineName));
        this.sinkPluginSettings.forEach(sinkPluginSettings -> this.updatePluginSetting((PluginSetting)sinkPluginSettings, pipelineName));
    }

    private void updatePluginSetting(PluginSetting pluginSetting, String pipelineName) {
        pluginSetting.setPipelineName(pipelineName);
        pluginSetting.setProcessWorkers(this.workers.intValue());
    }

    private PluginSetting getSourceFromPluginModel(PluginModel pluginModel) {
        if (pluginModel == null) {
            return null;
        }
        return PipelineConfiguration.getPluginSettingFromPluginModel(pluginModel);
    }

    private PluginSetting getBufferFromPluginModelOrDefault(PluginModel pluginModel) {
        if (pluginModel == null) {
            return BlockingBuffer.getDefaultPluginSettings();
        }
        return PipelineConfiguration.getPluginSettingFromPluginModel(pluginModel);
    }

    private List<SinkContextPluginSetting> getSinksFromPluginModel(List<SinkModel> sinkConfigurations) {
        if (sinkConfigurations == null || sinkConfigurations.isEmpty()) {
            throw new IllegalArgumentException("Invalid configuration, at least one sink is required");
        }
        return sinkConfigurations.stream().map(PipelineConfiguration::getSinkContextPluginSettingFromSinkModel).collect(Collectors.toList());
    }

    private List<PluginSetting> getProcessorsFromPluginModel(List<PluginModel> processorConfigurations) {
        if (processorConfigurations == null || processorConfigurations.isEmpty()) {
            return Collections.emptyList();
        }
        return processorConfigurations.stream().map(PipelineConfiguration::getPluginSettingFromPluginModel).collect(Collectors.toList());
    }

    private static PluginSetting getPluginSettingFromPluginModel(PluginModel pluginModel) {
        Map settingsMap = Optional.ofNullable(pluginModel.getPluginSettings()).orElseGet(HashMap::new);
        return new PluginSetting(pluginModel.getPluginName(), settingsMap);
    }

    private static SinkContextPluginSetting getSinkContextPluginSettingFromSinkModel(SinkModel sinkModel) {
        Map settingsMap = Optional.ofNullable(sinkModel.getPluginSettings()).orElseGet(HashMap::new);
        List pipelineNames = sinkModel.getForwardConfig() == null ? null : sinkModel.getForwardConfig().getPipelineNames();
        return new SinkContextPluginSetting(sinkModel.getPluginName(), settingsMap, new SinkContext(sinkModel.getTagsTargetKey(), sinkModel.getRoutes(), sinkModel.getIncludeKeys(), sinkModel.getExcludeKeys(), pipelineNames));
    }

    private Integer getWorkersFromPipelineModel(PipelineModel pipelineModel) {
        Integer configuredWorkers = pipelineModel.getWorkers();
        this.validateConfiguration(configuredWorkers, WORKERS_COMPONENT);
        return configuredWorkers == null ? 1 : configuredWorkers;
    }

    private Integer getReadBatchDelayFromPipelineModel(PipelineModel pipelineModel) {
        Integer configuredDelay = pipelineModel.getReadBatchDelay();
        if (configuredDelay != null && configuredDelay < 0) {
            throw new IllegalArgumentException(String.format("Invalid configuration, %s must be a non-negative integer.", DELAY_COMPONENT));
        }
        return configuredDelay == null ? 3000 : configuredDelay;
    }

    private void validateConfiguration(Integer configuration, String component) {
        if (configuration != null && configuration <= 0) {
            throw new IllegalArgumentException(String.format("Invalid configuration, %s cannot be %s", component, configuration));
        }
    }
}

