/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.grpc.protocol;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.grpc.protocol.AbstractMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.Decompressor;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.stream.HttpDecoder;
import com.linecorp.armeria.common.stream.StreamDecoderInput;
import com.linecorp.armeria.common.stream.StreamDecoderOutput;
import com.linecorp.armeria.internal.common.grpc.protocol.Base64Decoder;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Objects;

@UnstableApi
public class ArmeriaMessageDeframer
extends AbstractMessageDeframer
implements HttpDecoder<DeframedMessage> {
    @Nullable
    private final Base64Decoder base64Decoder;
    private boolean startedDeframing;

    public ArmeriaMessageDeframer(int maxMessageLength) {
        super(maxMessageLength);
        this.base64Decoder = null;
    }

    public ArmeriaMessageDeframer(int maxMessageLength, ByteBufAllocator alloc, boolean grpcWebText) {
        super(maxMessageLength);
        Objects.requireNonNull(alloc, "alloc");
        this.base64Decoder = grpcWebText ? new Base64Decoder(alloc) : null;
    }

    public ByteBuf toByteBuf(HttpData in) {
        if (this.base64Decoder != null) {
            return this.base64Decoder.decode(in.byteBuf());
        }
        return in.byteBuf();
    }

    public void process(StreamDecoderInput in, StreamDecoderOutput<DeframedMessage> out) throws Exception {
        int length;
        this.startedDeframing = true;
        for (int readableBytes = in.readableBytes(); readableBytes >= this.requiredLength(); readableBytes -= length) {
            length = this.requiredLength();
            if (this.isUninitializedType()) {
                this.readHeader(in);
                continue;
            }
            out.add((Object)this.readBody(in));
        }
    }

    @Override
    public ArmeriaMessageDeframer decompressor(@Nullable Decompressor decompressor) {
        Preconditions.checkState((!this.startedDeframing ? 1 : 0) != 0, (Object)"Deframing has already started, cannot change decompressor mid-stream.");
        return (ArmeriaMessageDeframer)super.decompressor(decompressor);
    }
}

