/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.crowdstrike;

import io.micrometer.core.instrument.Timer;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.source.crowdstrike.models.CrowdStrikeIndicatorResult;
import org.opensearch.dataprepper.plugins.source.crowdstrike.models.CrowdStrikeThreatIntelApiResponse;
import org.opensearch.dataprepper.plugins.source.crowdstrike.rest.CrowdStrikeRestClient;
import org.opensearch.dataprepper.plugins.source.crowdstrike.utils.CrowdStrikeNextLinkValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.util.UriComponentsBuilder;

@Named
public class CrowdStrikeService {
    private final CrowdStrikeRestClient crowdStrikeRestClient;
    private static final Logger log = LoggerFactory.getLogger(CrowdStrikeService.class);
    private static final String BASE_URL = "https://api.crowdstrike.com/";
    private static final String COMBINED_URL = "https://api.crowdstrike.com/intel/combined/indicators/v1";
    private final Timer searchCallLatencyTimer;
    private static final String GREATER_THAN_EQUALS = ">=";
    private static final String LESS_THAN = "<";
    private static final String ENCODED_PLUS_SIGN = "%2B";

    public CrowdStrikeService(CrowdStrikeRestClient crowdStrikeRestClient, PluginMetrics pluginMetrics) {
        this.crowdStrikeRestClient = crowdStrikeRestClient;
        this.searchCallLatencyTimer = pluginMetrics.timer("searchCallLatencyTimer");
    }

    public CrowdStrikeThreatIntelApiResponse getThreatIndicators(Instant startTime, Instant endTime, Optional<String> paginationLink) {
        if (startTime == null || endTime == null) {
            throw new IllegalArgumentException("startTime and endTime must not be null");
        }
        URI uri = this.buildCrowdStrikeUri(startTime, endTime, paginationLink);
        return (CrowdStrikeThreatIntelApiResponse)this.searchCallLatencyTimer.record(() -> {
            log.debug("Calling CrowdStrike API with URI: {}", (Object)uri);
            ResponseEntity<CrowdStrikeIndicatorResult> responseEntity = this.crowdStrikeRestClient.invokeGetApi(uri, CrowdStrikeIndicatorResult.class);
            return new CrowdStrikeThreatIntelApiResponse((CrowdStrikeIndicatorResult)responseEntity.getBody(), (Map<String, List<String>>)responseEntity.getHeaders());
        });
    }

    protected URI buildCrowdStrikeUri(Instant startTime, Instant endTime, Optional<String> paginationLink) {
        try {
            if (paginationLink.isPresent()) {
                Object urlString = BASE_URL + paginationLink.get();
                urlString = CrowdStrikeNextLinkValidator.validateAndSanitizeURL((String)urlString);
                return new URI((String)urlString);
            }
            String startTimeFilter = URLEncoder.encode("last_updated:>=" + startTime.getEpochSecond(), StandardCharsets.UTF_8);
            String endTimeFilter = URLEncoder.encode("last_updated:<" + endTime.getEpochSecond(), StandardCharsets.UTF_8);
            String encodedFilter = startTimeFilter + ENCODED_PLUS_SIGN + endTimeFilter;
            UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)COMBINED_URL).queryParam("filter", new Object[]{encodedFilter}).queryParam("limit", new Object[]{10000});
            return builder.build(true).toUri();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to construct CrowdStrike request URI", e);
        }
    }
}

