/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate.actions;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateAction;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionInput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionOutput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionResponse;
import org.opensearch.dataprepper.plugins.processor.aggregate.GroupState;
import org.opensearch.dataprepper.plugins.processor.aggregate.actions.TailSamplerAggregateActionConfig;

@DataPrepperPlugin(name="tail_sampler", pluginType=AggregateAction.class, pluginConfigurationType=TailSamplerAggregateActionConfig.class)
public class TailSamplerAggregateAction
implements AggregateAction {
    static final String LAST_RECEIVED_TIME_KEY = "last_received_time";
    static final String SHOULD_CONCLUDE_CHECK_SET_KEY = "should_conclude_check_set";
    static final String EVENTS_KEY = "events";
    static final String ERROR_STATUS_KEY = "error_status";
    private final int percent;
    private final Duration waitPeriod;
    private final ExpressionEvaluator expressionEvaluator;
    private final String condition;
    private boolean shouldCarryGroupState;
    private Random random;

    @DataPrepperPluginConstructor
    public TailSamplerAggregateAction(TailSamplerAggregateActionConfig tailSamplerAggregateActionConfig, ExpressionEvaluator expressionEvaluator) {
        this.percent = tailSamplerAggregateActionConfig.getPercent();
        this.waitPeriod = tailSamplerAggregateActionConfig.getWaitPeriod();
        this.condition = tailSamplerAggregateActionConfig.getCondition();
        this.random = new Random();
        this.expressionEvaluator = expressionEvaluator;
        this.shouldCarryGroupState = true;
    }

    @Override
    public AggregateActionResponse handleEvent(Event event, AggregateActionInput aggregateActionInput) {
        GroupState groupState = aggregateActionInput.getGroupState();
        if (!groupState.getOrDefault(SHOULD_CONCLUDE_CHECK_SET_KEY, false).booleanValue()) {
            aggregateActionInput.setCustomShouldConclude(duration -> {
                Duration timeDiff = Duration.between(groupState.getOrDefault(LAST_RECEIVED_TIME_KEY, Instant.now()), Instant.now());
                return timeDiff.toSeconds() >= this.waitPeriod.toSeconds();
            });
            groupState.put(SHOULD_CONCLUDE_CHECK_SET_KEY, true);
        }
        List events = groupState.getOrDefault(EVENTS_KEY, new ArrayList());
        events.add(event);
        groupState.put(EVENTS_KEY, events);
        if (this.condition != null && !this.condition.isEmpty() && this.expressionEvaluator.evaluateConditional(this.condition, event).booleanValue()) {
            groupState.put(ERROR_STATUS_KEY, true);
        }
        groupState.put(LAST_RECEIVED_TIME_KEY, Instant.now());
        return AggregateActionResponse.nullEventResponse();
    }

    @Override
    public boolean holdsEvents() {
        return true;
    }

    @Override
    public AggregateActionOutput concludeGroup(AggregateActionInput aggregateActionInput) {
        GroupState groupState = aggregateActionInput.getGroupState();
        if (groupState.isEmpty()) {
            return null;
        }
        int randomInt = this.random.nextInt(100);
        aggregateActionInput.getEventHandle().release(true);
        if (groupState.containsKey(ERROR_STATUS_KEY) && ((Boolean)groupState.get(ERROR_STATUS_KEY)).booleanValue() || randomInt < this.percent) {
            return new AggregateActionOutput(groupState.getOrDefault(EVENTS_KEY, List.of()));
        }
        List events = groupState.getOrDefault(EVENTS_KEY, List.of());
        for (Event event : events) {
            EventHandle eventHandle = event.getEventHandle();
            if (eventHandle == null) continue;
            eventHandle.release(true);
        }
        return new AggregateActionOutput(Collections.emptyList());
    }
}

