/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.s3.accumulator;

import java.io.IOException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang3.time.StopWatch;
import org.opensearch.dataprepper.plugins.codec.parquet.S3OutputStream;
import org.opensearch.dataprepper.plugins.sink.s3.accumulator.Buffer;

public class MultipartBuffer
implements Buffer {
    private int eventCount;
    private final StopWatch watch;
    private boolean isCodecStarted;
    private S3OutputStream s3OutputStream;

    MultipartBuffer(S3OutputStream s3OutputStream) {
        this.s3OutputStream = s3OutputStream;
        this.eventCount = 0;
        this.watch = new StopWatch();
        this.watch.start();
        this.isCodecStarted = false;
    }

    @Override
    public long getSize() {
        try {
            return this.s3OutputStream.getPos();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getEventCount() {
        return this.eventCount;
    }

    @Override
    public Duration getDuration() {
        return Duration.ofMillis(this.watch.getTime(TimeUnit.MILLISECONDS));
    }

    @Override
    public Optional<CompletableFuture<?>> flushToS3(Consumer<Boolean> runOnCompletion, Consumer<Throwable> runOnFailure) {
        return Optional.ofNullable(this.s3OutputStream.close(runOnCompletion, runOnFailure));
    }

    @Override
    public void setEventCount(int eventCount) {
        this.eventCount = eventCount;
    }

    @Override
    public String getKey() {
        return this.s3OutputStream.getKey();
    }

    public S3OutputStream getOutputStream() {
        return this.s3OutputStream;
    }
}

