/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack;

import co.elastic.clients.elasticsearch.xpack.info.BuildInformation;
import co.elastic.clients.elasticsearch.xpack.info.Features;
import co.elastic.clients.elasticsearch.xpack.info.MinimalLicenseInformation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class XpackInfoResponse
implements JsonpSerializable {
    private final BuildInformation build;
    private final Features features;
    private final MinimalLicenseInformation license;
    private final String tagline;
    public static final JsonpDeserializer<XpackInfoResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, XpackInfoResponse::setupXpackInfoResponseDeserializer);

    private XpackInfoResponse(Builder builder) {
        this.build = ApiTypeHelper.requireNonNull(builder.build, this, "build");
        this.features = ApiTypeHelper.requireNonNull(builder.features, this, "features");
        this.license = ApiTypeHelper.requireNonNull(builder.license, this, "license");
        this.tagline = ApiTypeHelper.requireNonNull(builder.tagline, this, "tagline");
    }

    public static XpackInfoResponse of(Function<Builder, ObjectBuilder<XpackInfoResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final BuildInformation build() {
        return this.build;
    }

    public final Features features() {
        return this.features;
    }

    public final MinimalLicenseInformation license() {
        return this.license;
    }

    public final String tagline() {
        return this.tagline;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("build");
        this.build.serialize(generator, mapper);
        generator.writeKey("features");
        this.features.serialize(generator, mapper);
        generator.writeKey("license");
        this.license.serialize(generator, mapper);
        generator.writeKey("tagline");
        generator.write(this.tagline);
    }

    protected static void setupXpackInfoResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::build, BuildInformation._DESERIALIZER, "build");
        op.add(Builder::features, Features._DESERIALIZER, "features");
        op.add(Builder::license, MinimalLicenseInformation._DESERIALIZER, "license");
        op.add(Builder::tagline, JsonpDeserializer.stringDeserializer(), "tagline");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<XpackInfoResponse> {
        private BuildInformation build;
        private Features features;
        private MinimalLicenseInformation license;
        private String tagline;

        public final Builder build(BuildInformation value) {
            this.build = value;
            return this;
        }

        public final Builder build(Function<BuildInformation.Builder, ObjectBuilder<BuildInformation>> fn) {
            return this.build(fn.apply(new BuildInformation.Builder()).build());
        }

        public final Builder features(Features value) {
            this.features = value;
            return this;
        }

        public final Builder features(Function<Features.Builder, ObjectBuilder<Features>> fn) {
            return this.features(fn.apply(new Features.Builder()).build());
        }

        public final Builder license(MinimalLicenseInformation value) {
            this.license = value;
            return this;
        }

        public final Builder license(Function<MinimalLicenseInformation.Builder, ObjectBuilder<MinimalLicenseInformation>> fn) {
            return this.license(fn.apply(new MinimalLicenseInformation.Builder()).build());
        }

        public final Builder tagline(String value) {
            this.tagline = value;
            return this;
        }

        @Override
        public XpackInfoResponse build() {
            this._checkSingleUse();
            return new XpackInfoResponse(this);
        }
    }
}

