/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ExecutionThreadPool
implements JsonpSerializable {
    private final long maxSize;
    private final long queueSize;
    public static final JsonpDeserializer<ExecutionThreadPool> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExecutionThreadPool::setupExecutionThreadPoolDeserializer);

    private ExecutionThreadPool(Builder builder) {
        this.maxSize = ApiTypeHelper.requireNonNull(builder.maxSize, this, "maxSize");
        this.queueSize = ApiTypeHelper.requireNonNull(builder.queueSize, this, "queueSize");
    }

    public static ExecutionThreadPool of(Function<Builder, ObjectBuilder<ExecutionThreadPool>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long maxSize() {
        return this.maxSize;
    }

    public final long queueSize() {
        return this.queueSize;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("max_size");
        generator.write(this.maxSize);
        generator.writeKey("queue_size");
        generator.write(this.queueSize);
    }

    protected static void setupExecutionThreadPoolDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::maxSize, JsonpDeserializer.longDeserializer(), "max_size");
        op.add(Builder::queueSize, JsonpDeserializer.longDeserializer(), "queue_size");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ExecutionThreadPool> {
        private Long maxSize;
        private Long queueSize;

        public final Builder maxSize(long value) {
            this.maxSize = value;
            return this;
        }

        public final Builder queueSize(long value) {
            this.queueSize = value;
            return this;
        }

        @Override
        public ExecutionThreadPool build() {
            this._checkSingleUse();
            return new ExecutionThreadPool(this);
        }
    }
}

