/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.ClusterAppliedStats;
import co.elastic.clients.elasticsearch.nodes.ClusterStateQueue;
import co.elastic.clients.elasticsearch.nodes.ClusterStateUpdate;
import co.elastic.clients.elasticsearch.nodes.PublishedClusterStates;
import co.elastic.clients.elasticsearch.nodes.SerializedClusterState;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Discovery
implements JsonpSerializable {
    @Nullable
    private final ClusterStateQueue clusterStateQueue;
    @Nullable
    private final PublishedClusterStates publishedClusterStates;
    private final Map<String, ClusterStateUpdate> clusterStateUpdate;
    @Nullable
    private final SerializedClusterState serializedClusterStates;
    @Nullable
    private final ClusterAppliedStats clusterApplierStats;
    public static final JsonpDeserializer<Discovery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Discovery::setupDiscoveryDeserializer);

    private Discovery(Builder builder) {
        this.clusterStateQueue = builder.clusterStateQueue;
        this.publishedClusterStates = builder.publishedClusterStates;
        this.clusterStateUpdate = ApiTypeHelper.unmodifiable(builder.clusterStateUpdate);
        this.serializedClusterStates = builder.serializedClusterStates;
        this.clusterApplierStats = builder.clusterApplierStats;
    }

    public static Discovery of(Function<Builder, ObjectBuilder<Discovery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ClusterStateQueue clusterStateQueue() {
        return this.clusterStateQueue;
    }

    @Nullable
    public final PublishedClusterStates publishedClusterStates() {
        return this.publishedClusterStates;
    }

    public final Map<String, ClusterStateUpdate> clusterStateUpdate() {
        return this.clusterStateUpdate;
    }

    @Nullable
    public final SerializedClusterState serializedClusterStates() {
        return this.serializedClusterStates;
    }

    @Nullable
    public final ClusterAppliedStats clusterApplierStats() {
        return this.clusterApplierStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.clusterStateQueue != null) {
            generator.writeKey("cluster_state_queue");
            this.clusterStateQueue.serialize(generator, mapper);
        }
        if (this.publishedClusterStates != null) {
            generator.writeKey("published_cluster_states");
            this.publishedClusterStates.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.clusterStateUpdate)) {
            generator.writeKey("cluster_state_update");
            generator.writeStartObject();
            for (Map.Entry<String, ClusterStateUpdate> item0 : this.clusterStateUpdate.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.serializedClusterStates != null) {
            generator.writeKey("serialized_cluster_states");
            this.serializedClusterStates.serialize(generator, mapper);
        }
        if (this.clusterApplierStats != null) {
            generator.writeKey("cluster_applier_stats");
            this.clusterApplierStats.serialize(generator, mapper);
        }
    }

    protected static void setupDiscoveryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusterStateQueue, ClusterStateQueue._DESERIALIZER, "cluster_state_queue");
        op.add(Builder::publishedClusterStates, PublishedClusterStates._DESERIALIZER, "published_cluster_states");
        op.add(Builder::clusterStateUpdate, JsonpDeserializer.stringMapDeserializer(ClusterStateUpdate._DESERIALIZER), "cluster_state_update");
        op.add(Builder::serializedClusterStates, SerializedClusterState._DESERIALIZER, "serialized_cluster_states");
        op.add(Builder::clusterApplierStats, ClusterAppliedStats._DESERIALIZER, "cluster_applier_stats");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Discovery> {
        @Nullable
        private ClusterStateQueue clusterStateQueue;
        @Nullable
        private PublishedClusterStates publishedClusterStates;
        @Nullable
        private Map<String, ClusterStateUpdate> clusterStateUpdate;
        @Nullable
        private SerializedClusterState serializedClusterStates;
        @Nullable
        private ClusterAppliedStats clusterApplierStats;

        public final Builder clusterStateQueue(@Nullable ClusterStateQueue value) {
            this.clusterStateQueue = value;
            return this;
        }

        public final Builder clusterStateQueue(Function<ClusterStateQueue.Builder, ObjectBuilder<ClusterStateQueue>> fn) {
            return this.clusterStateQueue(fn.apply(new ClusterStateQueue.Builder()).build());
        }

        public final Builder publishedClusterStates(@Nullable PublishedClusterStates value) {
            this.publishedClusterStates = value;
            return this;
        }

        public final Builder publishedClusterStates(Function<PublishedClusterStates.Builder, ObjectBuilder<PublishedClusterStates>> fn) {
            return this.publishedClusterStates(fn.apply(new PublishedClusterStates.Builder()).build());
        }

        public final Builder clusterStateUpdate(Map<String, ClusterStateUpdate> map) {
            this.clusterStateUpdate = Builder._mapPutAll(this.clusterStateUpdate, map);
            return this;
        }

        public final Builder clusterStateUpdate(String key, ClusterStateUpdate value) {
            this.clusterStateUpdate = Builder._mapPut(this.clusterStateUpdate, key, value);
            return this;
        }

        public final Builder clusterStateUpdate(String key, Function<ClusterStateUpdate.Builder, ObjectBuilder<ClusterStateUpdate>> fn) {
            return this.clusterStateUpdate(key, fn.apply(new ClusterStateUpdate.Builder()).build());
        }

        public final Builder serializedClusterStates(@Nullable SerializedClusterState value) {
            this.serializedClusterStates = value;
            return this;
        }

        public final Builder serializedClusterStates(Function<SerializedClusterState.Builder, ObjectBuilder<SerializedClusterState>> fn) {
            return this.serializedClusterStates(fn.apply(new SerializedClusterState.Builder()).build());
        }

        public final Builder clusterApplierStats(@Nullable ClusterAppliedStats value) {
            this.clusterApplierStats = value;
            return this;
        }

        public final Builder clusterApplierStats(Function<ClusterAppliedStats.Builder, ObjectBuilder<ClusterAppliedStats>> fn) {
            return this.clusterApplierStats(fn.apply(new ClusterAppliedStats.Builder()).build());
        }

        @Override
        public Discovery build() {
            this._checkSingleUse();
            return new Discovery(this);
        }
    }
}

