/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.indices.validate_query.IndicesValidationExplanation;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ValidateQueryResponse
implements JsonpSerializable {
    private final List<IndicesValidationExplanation> explanations;
    @Nullable
    private final ShardStatistics shards;
    private final boolean valid;
    @Nullable
    private final String error;
    public static final JsonpDeserializer<ValidateQueryResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ValidateQueryResponse::setupValidateQueryResponseDeserializer);

    private ValidateQueryResponse(Builder builder) {
        this.explanations = ApiTypeHelper.unmodifiable(builder.explanations);
        this.shards = builder.shards;
        this.valid = ApiTypeHelper.requireNonNull(builder.valid, this, "valid");
        this.error = builder.error;
    }

    public static ValidateQueryResponse of(Function<Builder, ObjectBuilder<ValidateQueryResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<IndicesValidationExplanation> explanations() {
        return this.explanations;
    }

    @Nullable
    public final ShardStatistics shards() {
        return this.shards;
    }

    public final boolean valid() {
        return this.valid;
    }

    @Nullable
    public final String error() {
        return this.error;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.explanations)) {
            generator.writeKey("explanations");
            generator.writeStartArray();
            for (IndicesValidationExplanation item0 : this.explanations) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.shards != null) {
            generator.writeKey("_shards");
            this.shards.serialize(generator, mapper);
        }
        generator.writeKey("valid");
        generator.write(this.valid);
        if (this.error != null) {
            generator.writeKey("error");
            generator.write(this.error);
        }
    }

    protected static void setupValidateQueryResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::explanations, JsonpDeserializer.arrayDeserializer(IndicesValidationExplanation._DESERIALIZER), "explanations");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::valid, JsonpDeserializer.booleanDeserializer(), "valid");
        op.add(Builder::error, JsonpDeserializer.stringDeserializer(), "error");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ValidateQueryResponse> {
        @Nullable
        private List<IndicesValidationExplanation> explanations;
        @Nullable
        private ShardStatistics shards;
        private Boolean valid;
        @Nullable
        private String error;

        public final Builder explanations(List<IndicesValidationExplanation> list) {
            this.explanations = Builder._listAddAll(this.explanations, list);
            return this;
        }

        public final Builder explanations(IndicesValidationExplanation value, IndicesValidationExplanation ... values) {
            this.explanations = Builder._listAdd(this.explanations, value, values);
            return this;
        }

        public final Builder explanations(Function<IndicesValidationExplanation.Builder, ObjectBuilder<IndicesValidationExplanation>> fn) {
            return this.explanations(fn.apply(new IndicesValidationExplanation.Builder()).build(), new IndicesValidationExplanation[0]);
        }

        public final Builder shards(@Nullable ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder valid(boolean value) {
            this.valid = value;
            return this;
        }

        public final Builder error(@Nullable String value) {
            this.error = value;
            return this;
        }

        @Override
        public ValidateQueryResponse build() {
            this._checkSingleUse();
            return new ValidateQueryResponse(this);
        }
    }
}

