/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.CompletionSuggest;
import co.elastic.clients.elasticsearch.core.search.PhraseSuggest;
import co.elastic.clients.elasticsearch.core.search.SuggestionVariant;
import co.elastic.clients.elasticsearch.core.search.TermSuggest;
import co.elastic.clients.json.ExternallyTaggedUnion;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;

public class Suggestion<TDocument>
implements TaggedUnion<Kind, SuggestionVariant>,
JsonpSerializable {
    private final Kind _kind;
    private final SuggestionVariant _value;
    private final JsonpSerializer<TDocument> tDocumentSerializer = null;

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final SuggestionVariant _get() {
        return this._value;
    }

    public Suggestion(SuggestionVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._suggestionKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
    }

    private Suggestion(Builder<TDocument> builder) {
        this._kind = ApiTypeHelper.requireNonNull(((Builder)builder)._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(((Builder)builder)._value, builder, "<variant value>");
    }

    public static <TDocument> Suggestion<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<Suggestion<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCompletion() {
        return this._kind == Kind.Completion;
    }

    public CompletionSuggest<TDocument> completion() {
        return (CompletionSuggest)TaggedUnionUtils.get(this, Kind.Completion);
    }

    public boolean isPhrase() {
        return this._kind == Kind.Phrase;
    }

    public PhraseSuggest phrase() {
        return (PhraseSuggest)TaggedUnionUtils.get(this, Kind.Phrase);
    }

    public boolean isTerm() {
        return this._kind == Kind.Term;
    }

    public TermSuggest term() {
        return (TermSuggest)TaggedUnionUtils.get(this, Kind.Term);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        mapper.serialize(this._value, generator);
    }

    public static <TDocument> ExternallyTaggedUnion.TypedKeysDeserializer<Suggestion<TDocument>> createSuggestionDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        HashMap deserializers = new HashMap();
        deserializers.put("completion", CompletionSuggest.createCompletionSuggestDeserializer(tDocumentDeserializer));
        deserializers.put("phrase", PhraseSuggest._DESERIALIZER);
        deserializers.put("term", TermSuggest._DESERIALIZER);
        return new ExternallyTaggedUnion.Deserializer<Suggestion, SuggestionVariant>(deserializers, (name, value) -> new Suggestion((SuggestionVariant)value)).typedKeys();
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements ObjectBuilder<Suggestion<TDocument>> {
        private Kind _kind;
        private SuggestionVariant _value;

        public ObjectBuilder<Suggestion<TDocument>> completion(CompletionSuggest<TDocument> v) {
            this._kind = Kind.Completion;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Suggestion<TDocument>> completion(Function<CompletionSuggest.Builder<TDocument>, ObjectBuilder<CompletionSuggest<TDocument>>> fn) {
            return this.completion(fn.apply(new CompletionSuggest.Builder()).build());
        }

        public ObjectBuilder<Suggestion<TDocument>> phrase(PhraseSuggest v) {
            this._kind = Kind.Phrase;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Suggestion<TDocument>> phrase(Function<PhraseSuggest.Builder, ObjectBuilder<PhraseSuggest>> fn) {
            return this.phrase(fn.apply(new PhraseSuggest.Builder()).build());
        }

        public ObjectBuilder<Suggestion<TDocument>> term(TermSuggest v) {
            this._kind = Kind.Term;
            this._value = v;
            return this;
        }

        public ObjectBuilder<Suggestion<TDocument>> term(Function<TermSuggest.Builder, ObjectBuilder<TermSuggest>> fn) {
            return this.term(fn.apply(new TermSuggest.Builder()).build());
        }

        @Override
        public Suggestion<TDocument> build() {
            this._checkSingleUse();
            return new Suggestion(this);
        }
    }

    public static enum Kind implements JsonEnum
    {
        Completion("completion"),
        Phrase("phrase"),
        Term("term");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }
}

