/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ccr;

import co.elastic.clients.elasticsearch.ccr.stats.AutoFollowStats;
import co.elastic.clients.elasticsearch.ccr.stats.FollowStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class CcrStatsResponse
implements JsonpSerializable {
    private final AutoFollowStats autoFollowStats;
    private final FollowStats followStats;
    public static final JsonpDeserializer<CcrStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CcrStatsResponse::setupCcrStatsResponseDeserializer);

    private CcrStatsResponse(Builder builder) {
        this.autoFollowStats = ApiTypeHelper.requireNonNull(builder.autoFollowStats, this, "autoFollowStats");
        this.followStats = ApiTypeHelper.requireNonNull(builder.followStats, this, "followStats");
    }

    public static CcrStatsResponse of(Function<Builder, ObjectBuilder<CcrStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final AutoFollowStats autoFollowStats() {
        return this.autoFollowStats;
    }

    public final FollowStats followStats() {
        return this.followStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("auto_follow_stats");
        this.autoFollowStats.serialize(generator, mapper);
        generator.writeKey("follow_stats");
        this.followStats.serialize(generator, mapper);
    }

    protected static void setupCcrStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::autoFollowStats, AutoFollowStats._DESERIALIZER, "auto_follow_stats");
        op.add(Builder::followStats, FollowStats._DESERIALIZER, "follow_stats");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CcrStatsResponse> {
        private AutoFollowStats autoFollowStats;
        private FollowStats followStats;

        public final Builder autoFollowStats(AutoFollowStats value) {
            this.autoFollowStats = value;
            return this;
        }

        public final Builder autoFollowStats(Function<AutoFollowStats.Builder, ObjectBuilder<AutoFollowStats>> fn) {
            return this.autoFollowStats(fn.apply(new AutoFollowStats.Builder()).build());
        }

        public final Builder followStats(FollowStats value) {
            this.followStats = value;
            return this;
        }

        public final Builder followStats(Function<FollowStats.Builder, ObjectBuilder<FollowStats>> fn) {
            return this.followStats(fn.apply(new FollowStats.Builder()).build());
        }

        @Override
        public CcrStatsResponse build() {
            this._checkSingleUse();
            return new CcrStatsResponse(this);
        }
    }
}

