/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.util;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Mapper {
    private static final Logger LOGGER = Logger.getLogger("com.apptasticsoftware.rssreader.util");

    private Mapper() {
    }

    public static void mapBoolean(String text, Consumer<Boolean> func) {
        if ("true".equals(text = text.toLowerCase()) || "yes".equals(text)) {
            func.accept(Boolean.TRUE);
        } else if ("false".equals(text) || "no".equals(text)) {
            func.accept(Boolean.FALSE);
        }
    }

    public static void mapInteger(String text, Consumer<Integer> func) {
        Mapper.mapNumber(text, func, Integer::valueOf);
    }

    public static void mapLong(String text, Consumer<Long> func) {
        Mapper.mapNumber(text, func, Long::valueOf);
    }

    private static <T> void mapNumber(String text, Consumer<T> func, Function<String, T> convert) {
        block3: {
            if (Mapper.isNotNullOrEmpty(text)) {
                try {
                    func.accept(convert.apply(text));
                }
                catch (NumberFormatException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block3;
                    LOGGER.log(Level.WARNING, () -> String.format("Failed to convert %s. Message: %s", text, e.getMessage()));
                }
            }
        }
    }

    public static <T> void mapIfEmpty(String text, Supplier<T> getter, Consumer<String> setter) {
        if (Mapper.isNullOrEmpty(getter) && Mapper.isNotNullOrEmpty(text)) {
            setter.accept(text);
        }
    }

    public static <T> T createIfNull(Supplier<Optional<T>> getter, Consumer<T> setter, Supplier<T> factory) {
        return Mapper.createIfNullOptional(getter, setter, factory).orElse(null);
    }

    public static <T> Optional<T> createIfNullOptional(Supplier<Optional<T>> getter, Consumer<T> setter, Supplier<T> factory) {
        Optional<T> instance = getter.get();
        if (instance.isEmpty()) {
            T newInstance = factory.get();
            setter.accept(newInstance);
            instance = Optional.of(newInstance);
        }
        return instance;
    }

    public static <T> List<T> emptyListIfNull(List<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> boolean isNullOrEmpty(Supplier<T> getter) {
        if (getter.get() == null) return true;
        if ("".equals(getter.get())) return true;
        if (getter.get() == Optional.empty()) return true;
        if (!(getter.get() instanceof Optional)) return false;
        if (((Optional)getter.get()).filter(String.class::isInstance).map(String.class::cast).map(String::isBlank).orElse(false) == false) return false;
        return true;
    }

    private static boolean isNullOrEmpty(String text) {
        return text == null || text.isBlank();
    }

    private static boolean isNotNullOrEmpty(String text) {
        return !Mapper.isNullOrEmpty(text);
    }
}

