/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.confluence;

import com.google.common.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.inject.Named;
import org.opensearch.dataprepper.plugins.source.confluence.ConfluenceService;
import org.opensearch.dataprepper.plugins.source.confluence.ConfluenceSourceConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.PluginExecutorServiceProvider;
import org.opensearch.dataprepper.plugins.source.source_crawler.model.ItemInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class ConfluenceIterator
implements Iterator<ItemInfo> {
    private static final int HAS_NEXT_TIMEOUT = 60;
    private static final Logger log = LoggerFactory.getLogger(ConfluenceIterator.class);
    private long crawlerQWaitTimeMillis = 2000L;
    private Queue<ItemInfo> itemInfoQueue;
    private Instant lastPollTime;
    private boolean firstTime = true;
    private final List<Future<Boolean>> futureList = new ArrayList<Future<Boolean>>();
    private final ConfluenceSourceConfig sourceConfig;
    private final ConfluenceService service;
    private final ExecutorService crawlerTaskExecutor;

    public ConfluenceIterator(ConfluenceService service, PluginExecutorServiceProvider executorServiceProvider, ConfluenceSourceConfig sourceConfig) {
        this.service = service;
        this.crawlerTaskExecutor = executorServiceProvider.get();
        this.sourceConfig = sourceConfig;
    }

    @Override
    public boolean hasNext() {
        if (this.firstTime) {
            log.trace("Crawling has been started");
            this.startCrawlerThreads();
            this.firstTime = false;
        }
        int timeout = 60;
        while (this.isCrawlerRunning() && this.itemInfoQueue.isEmpty() && timeout > 0) {
            try {
                log.trace("Waiting for crawler queue to be filled for next {} seconds", (Object)timeout);
                Thread.sleep(this.crawlerQWaitTimeMillis);
                --timeout;
            }
            catch (InterruptedException e) {
                log.error("An exception has occurred while checking for the next document in crawling queue");
                Thread.currentThread().interrupt();
            }
        }
        return !this.itemInfoQueue.isEmpty();
    }

    private boolean isCrawlerRunning() {
        boolean isRunning = false;
        if (!this.futureList.isEmpty()) {
            for (Future<Boolean> future : this.futureList) {
                if (future.isDone()) continue;
                isRunning = true;
                break;
            }
        }
        return isRunning;
    }

    private void startCrawlerThreads() {
        this.futureList.add(this.crawlerTaskExecutor.submit(() -> this.service.getPages(this.sourceConfig, this.lastPollTime, this.itemInfoQueue), false));
    }

    @Override
    public ItemInfo next() {
        if (this.hasNext()) {
            return this.itemInfoQueue.remove();
        }
        throw new NoSuchElementException();
    }

    public void initialize(Instant confluenceChangeLogToken) {
        this.itemInfoQueue = new ConcurrentLinkedQueue<ItemInfo>();
        this.lastPollTime = confluenceChangeLogToken;
        this.firstTime = true;
    }

    @VisibleForTesting
    public List<Future<Boolean>> showFutureList() {
        return this.futureList;
    }

    public void setCrawlerQWaitTimeMillis(long crawlerQWaitTimeMillis) {
        this.crawlerQWaitTimeMillis = crawlerQWaitTimeMillis;
    }
}

