/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.oteltrace;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.encoding.DecodingService;
import com.linecorp.armeria.server.healthcheck.HealthCheckService;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.codec.ByteDecoder;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.model.Certificate;
import org.opensearch.dataprepper.plugins.codec.CompressionOption;
import org.opensearch.dataprepper.plugins.otel.codec.OTelOutputFormat;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoOpensearchCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoStandardCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelTraceDecoder;
import org.opensearch.dataprepper.plugins.source.oteltrace.OTelTraceSourceConfig;
import org.opensearch.dataprepper.plugins.source.oteltrace.certificate.CertificateProviderFactory;
import org.opensearch.dataprepper.plugins.source.oteltrace.grpc.GrpcService;
import org.opensearch.dataprepper.plugins.source.oteltrace.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="otel_trace_source", pluginType=Source.class, pluginConfigurationType=OTelTraceSourceConfig.class)
public class OTelTraceSource
implements Source<Record<Object>> {
    private static final String PLUGIN_NAME = "otel_trace_source";
    private static final Logger LOG = LoggerFactory.getLogger(OTelTraceSource.class);
    private static final String HTTP_HEALTH_CHECK_PATH = "/health";
    static final String SERVER_CONNECTIONS = "serverConnections";
    private final OTelTraceSourceConfig oTelTraceSourceConfig;
    private final PluginMetrics pluginMetrics;
    private final PluginFactory pluginFactory;
    private final CertificateProviderFactory certificateProviderFactory;
    private final String pipelineName;
    private Server server;
    private final ByteDecoder byteDecoder;

    @DataPrepperPluginConstructor
    public OTelTraceSource(OTelTraceSourceConfig oTelTraceSourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, PipelineDescription pipelineDescription) {
        this(oTelTraceSourceConfig, pluginMetrics, pluginFactory, new CertificateProviderFactory(oTelTraceSourceConfig), pipelineDescription);
    }

    OTelTraceSource(OTelTraceSourceConfig oTelTraceSourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, CertificateProviderFactory certificateProviderFactory, PipelineDescription pipelineDescription) {
        oTelTraceSourceConfig.validateAndInitializeCertAndKeyFileInS3();
        this.oTelTraceSourceConfig = oTelTraceSourceConfig;
        this.pluginMetrics = pluginMetrics;
        this.pluginFactory = pluginFactory;
        this.certificateProviderFactory = certificateProviderFactory;
        this.pipelineName = pipelineDescription.getPipelineName();
        this.byteDecoder = new OTelTraceDecoder(oTelTraceSourceConfig.getOutputFormat());
    }

    public ByteDecoder getDecoder() {
        return this.byteDecoder;
    }

    public void start(Buffer<Record<Object>> buffer) {
        if (buffer == null) {
            throw new IllegalStateException("Buffer provided is null");
        }
        if (this.server == null) {
            ServerBuilder serverBuilder = Server.builder().port(this.oTelTraceSourceConfig.getPort(), new SessionProtocol[]{this.inferProtocolFromConfig()});
            this.configureHeadersAndHealthCheck(serverBuilder);
            this.configureTLS(serverBuilder);
            this.configureTaskExecutor(serverBuilder);
            OTelProtoOpensearchCodec.OTelProtoDecoder oTelProtoDecoder = this.oTelTraceSourceConfig.getOutputFormat() == OTelOutputFormat.OPENSEARCH ? new OTelProtoOpensearchCodec.OTelProtoDecoder() : new OTelProtoStandardCodec.OTelProtoDecoder();
            this.configureGrpcService(serverBuilder, (OTelProtoCodec.OTelProtoDecoder)oTelProtoDecoder, buffer);
            if (!this.oTelTraceSourceConfig.enableUnframedRequests()) {
                this.configureHttpService(serverBuilder, (OTelProtoCodec.OTelProtoDecoder)oTelProtoDecoder, buffer);
            }
            this.server = serverBuilder.build();
            this.pluginMetrics.gauge(SERVER_CONNECTIONS, (Object)this.server, Server::numConnections);
        }
        try {
            this.server.start().get();
        }
        catch (ExecutionException ex) {
            this.handleExecutionException(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        LOG.info("Started otel_trace_source on port {}...", (Object)this.oTelTraceSourceConfig.getPort());
    }

    private SessionProtocol inferProtocolFromConfig() {
        if (this.oTelTraceSourceConfig.isSsl()) {
            return SessionProtocol.HTTPS;
        }
        return SessionProtocol.HTTP;
    }

    private void handleExecutionException(ExecutionException ex) {
        if (ex.getCause() != null && ex.getCause() instanceof RuntimeException) {
            throw (RuntimeException)ex.getCause();
        }
        throw new RuntimeException(ex);
    }

    private void configureGrpcService(ServerBuilder serverBuilder, OTelProtoCodec.OTelProtoDecoder otelProtoDecoder, Buffer<Record<Object>> buffer) {
        com.linecorp.armeria.server.grpc.GrpcService grpcService = new GrpcService(this.pluginFactory, otelProtoDecoder, this.oTelTraceSourceConfig, this.pluginMetrics, this.pipelineName).create(buffer, serverBuilder);
        if (CompressionOption.NONE.equals((Object)this.oTelTraceSourceConfig.getCompression())) {
            serverBuilder.service((HttpServiceWithRoutes)grpcService, new Function[0]);
        } else {
            serverBuilder.service((HttpServiceWithRoutes)grpcService, new Function[]{DecodingService.newDecorator()});
        }
    }

    private void configureHttpService(ServerBuilder serverBuilder, OTelProtoCodec.OTelProtoDecoder otelProtoDecoder, Buffer<Record<Object>> buffer) {
        new HttpService(this.pluginMetrics, otelProtoDecoder, this.oTelTraceSourceConfig, this.pluginFactory).create(serverBuilder, buffer);
    }

    private void configureHeadersAndHealthCheck(ServerBuilder serverBuilder) {
        serverBuilder.disableServerHeader();
        if (this.oTelTraceSourceConfig.enableHttpHealthCheck()) {
            serverBuilder.service(HTTP_HEALTH_CHECK_PATH, (com.linecorp.armeria.server.HttpService)HealthCheckService.builder().longPolling(0L).build());
        }
        serverBuilder.requestTimeoutMillis((long)this.oTelTraceSourceConfig.getRequestTimeoutInMillis());
        if (this.oTelTraceSourceConfig.getMaxRequestLength() != null) {
            serverBuilder.maxRequestLength(this.oTelTraceSourceConfig.getMaxRequestLength().getBytes());
        }
        serverBuilder.maxNumConnections(this.oTelTraceSourceConfig.getMaxConnectionCount());
    }

    private void configureTLS(ServerBuilder serverBuilder) {
        if (this.oTelTraceSourceConfig.isSsl() || this.oTelTraceSourceConfig.useAcmCertForSSL()) {
            LOG.info("SSL/TLS is enabled.");
            CertificateProvider certificateProvider = this.certificateProviderFactory.getCertificateProvider();
            Certificate certificate = certificateProvider.getCertificate();
            serverBuilder.https(this.oTelTraceSourceConfig.getPort()).tls((InputStream)new ByteArrayInputStream(certificate.getCertificate().getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream(certificate.getPrivateKey().getBytes(StandardCharsets.UTF_8)));
        } else {
            LOG.warn("Creating otel_trace_source without SSL/TLS. This is not secure.");
            LOG.warn("In order to set up TLS for the otel_trace_source, go here: https://github.com/opensearch-project/data-prepper/tree/main/data-prepper-plugins/otel-trace-source#ssl");
            serverBuilder.http(this.oTelTraceSourceConfig.getPort());
        }
    }

    private void configureTaskExecutor(ServerBuilder serverBuilder) {
        BlockingTaskExecutor blockingTaskExecutor = BlockingTaskExecutor.builder().numThreads(this.oTelTraceSourceConfig.getThreadCount()).threadNamePrefix(this.pipelineName + "-otel_trace").build();
        serverBuilder.blockingTaskExecutor(blockingTaskExecutor, true);
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop().get();
            }
            catch (ExecutionException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getCause();
                }
                throw new RuntimeException(ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
        }
        LOG.info("Stopped otel_trace_source.");
    }
}

