/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sourcecoordinator.dynamodb;

import java.time.Duration;
import java.util.UUID;
import javax.inject.Named;
import org.opensearch.dataprepper.plugins.sourcecoordinator.dynamodb.DdbClientCustomRetryCondition;
import software.amazon.awssdk.arns.Arn;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

@Named
public class DynamoDbClientFactory {
    private static final int DYNAMO_CLIENT_RETRIES = Integer.MAX_VALUE;
    private static final long DYNAMO_CLIENT_BASE_BACKOFF_MILLIS = 1000L;
    private static final long DYNAMO_CLIENT_MAX_BACKOFF_MILLIS = 60000L;

    DynamoDbClient provideDynamoDbClient(String region, String stsRoleArn, String stsExternalId) {
        return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().region(Region.of((String)region))).credentialsProvider(DynamoDbClientFactory.getAwsCredentials(Region.of((String)region), stsRoleArn, stsExternalId))).overrideConfiguration(DynamoDbClientFactory.getClientOverrideConfiguration())).build();
    }

    private static ClientOverrideConfiguration getClientOverrideConfiguration() {
        EqualJitterBackoffStrategy backoffStrategy = EqualJitterBackoffStrategy.builder().baseDelay(Duration.ofMillis(1000L)).maxBackoffTime(Duration.ofMillis(60000L)).build();
        RetryPolicy retryPolicy = RetryPolicy.builder().numRetries(Integer.valueOf(Integer.MAX_VALUE)).retryCondition((RetryCondition)new DdbClientCustomRetryCondition()).backoffStrategy((BackoffStrategy)backoffStrategy).throttlingBackoffStrategy((BackoffStrategy)backoffStrategy).build();
        return (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().retryPolicy(retryPolicy).build();
    }

    private static AwsCredentialsProvider getAwsCredentials(Region region, String stsRoleArn, String stsExternalId) {
        DefaultCredentialsProvider awsCredentialsProvider;
        if (stsRoleArn != null && !stsRoleArn.isEmpty()) {
            try {
                Arn.fromString((String)stsRoleArn);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid ARN format for dynamodb sts_role_arn");
            }
            StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().region(region)).overrideConfiguration(DynamoDbClientFactory.getClientOverrideConfiguration())).build();
            AssumeRoleRequest.Builder assumeRoleRequestBuilder = AssumeRoleRequest.builder().roleSessionName("Dynamo-Source-Coordination-" + String.valueOf(UUID.randomUUID())).roleArn(stsRoleArn);
            if (stsExternalId != null && !stsExternalId.isEmpty()) {
                assumeRoleRequestBuilder = assumeRoleRequestBuilder.externalId(stsExternalId);
            }
            awsCredentialsProvider = ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest((AssumeRoleRequest)assumeRoleRequestBuilder.build()).build();
        } else {
            awsCredentialsProvider = DefaultCredentialsProvider.create();
        }
        return awsCredentialsProvider;
    }
}

