/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.antlr.v4.runtime.tree.ParseTree;
import org.opensearch.dataprepper.expression.Evaluator;
import org.opensearch.dataprepper.expression.ExpressionEvaluationException;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.expression.ExpressionParsingException;
import org.opensearch.dataprepper.expression.Parser;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;

@Named
class GenericExpressionEvaluator
implements ExpressionEvaluator {
    private final Parser<ParseTree> parser;
    private final Evaluator<ParseTree, Event> evaluator;

    @Inject
    public GenericExpressionEvaluator(Parser<ParseTree> parser, Evaluator<ParseTree, Event> evaluator) {
        this.parser = parser;
        this.evaluator = evaluator;
    }

    public Object evaluate(String statement, Event context) {
        ParseTree parseTree = null;
        try {
            parseTree = this.parser.parse(statement);
        }
        catch (Exception exception) {
            throw new ExpressionParsingException("Unable to parse statement \"" + statement + "\"", (Throwable)exception);
        }
        try {
            return this.evaluator.evaluate(parseTree, context);
        }
        catch (Exception exception) {
            throw new ExpressionEvaluationException("Unable to evaluate statement \"" + statement + "\"", (Throwable)exception);
        }
    }

    public Boolean isValidExpressionStatement(String statement) {
        try {
            this.parser.parse(statement);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Boolean isValidFormatExpression(String format) {
        int fromIndex = 0;
        int position = 0;
        while ((position = format.indexOf("${", fromIndex)) != -1) {
            int endPosition = format.indexOf("}", position + 1);
            if (endPosition == -1) {
                return false;
            }
            String name = format.substring(position + 2, endPosition);
            if (!JacksonEvent.isValidEventKey((String)name) && !this.isValidExpressionStatement(name).booleanValue()) {
                return false;
            }
            fromIndex = endPosition + 1;
        }
        return true;
    }

    public List<String> extractDynamicKeysFromFormatExpression(String format) {
        ArrayList<String> formatExpressionKeys = new ArrayList<String>();
        if (format == null) {
            return formatExpressionKeys;
        }
        int fromIndex = 0;
        int position = 0;
        while ((position = format.indexOf("${", fromIndex)) != -1) {
            int endPosition = format.indexOf("}", position + 1);
            if (endPosition == -1) {
                return formatExpressionKeys;
            }
            Object name = format.substring(position + 2, endPosition);
            if (JacksonEvent.isValidEventKey((String)name)) {
                if (!((String)name).startsWith("/")) {
                    name = "/" + (String)name;
                }
                formatExpressionKeys.add((String)name);
            }
            fromIndex = endPosition + 1;
        }
        return formatExpressionKeys;
    }

    public List<String> extractDynamicExpressionsFromFormatExpression(String format) {
        ArrayList<String> dynamicExpressionStatements = new ArrayList<String>();
        if (format == null) {
            return dynamicExpressionStatements;
        }
        int fromIndex = 0;
        int position = 0;
        while ((position = format.indexOf("${", fromIndex)) != -1) {
            int endPosition = format.indexOf("}", position + 1);
            if (endPosition == -1) {
                return dynamicExpressionStatements;
            }
            String name = format.substring(position + 2, endPosition);
            if (!JacksonEvent.isValidEventKey((String)name) && this.isValidExpressionStatement(name).booleanValue()) {
                dynamicExpressionStatements.add(name);
            }
            fromIndex = endPosition + 1;
        }
        return dynamicExpressionStatements;
    }
}

