/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3.ownership;

import java.net.MalformedURLException;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.plugins.s3.common.ownership.BucketOwnerProvider;
import org.opensearch.dataprepper.plugins.s3.common.ownership.MappedBucketOwnerProvider;
import org.opensearch.dataprepper.plugins.s3.common.ownership.NoOwnershipBucketOwnerProvider;
import org.opensearch.dataprepper.plugins.s3.common.ownership.StaticBucketOwnerProvider;
import org.opensearch.dataprepper.plugins.s3.common.source.StsArnRole;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceConfig;
import org.opensearch.dataprepper.plugins.source.s3.SqsQueueUrl;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;

public class ConfigBucketOwnerProviderFactory {
    private final AwsCredentialsProvider defaultAwsCredentialsProvider;

    public ConfigBucketOwnerProviderFactory(AwsCredentialsProvider defaultAwsCredentialsProvider) {
        this.defaultAwsCredentialsProvider = defaultAwsCredentialsProvider;
    }

    public BucketOwnerProvider createBucketOwnerProvider(S3SourceConfig s3SourceConfig) {
        if (s3SourceConfig.isDisableBucketOwnershipValidation()) {
            return new NoOwnershipBucketOwnerProvider();
        }
        StaticBucketOwnerProvider staticBucketOwnerProvider = this.getStaticBucketOwnerProvider(s3SourceConfig);
        if (s3SourceConfig.getBucketOwners() != null && !s3SourceConfig.getBucketOwners().isEmpty()) {
            return new MappedBucketOwnerProvider(s3SourceConfig.getBucketOwners(), (BucketOwnerProvider)staticBucketOwnerProvider);
        }
        return staticBucketOwnerProvider;
    }

    private StaticBucketOwnerProvider getStaticBucketOwnerProvider(S3SourceConfig s3SourceConfig) {
        String accountId = s3SourceConfig.getDefaultBucketOwner() != null ? s3SourceConfig.getDefaultBucketOwner() : (s3SourceConfig.getSqsOptions() != null ? this.extractQueueAccountId(s3SourceConfig) : (s3SourceConfig.getAwsAuthenticationOptions() != null && s3SourceConfig.getAwsAuthenticationOptions().getAwsStsRoleArn() != null ? this.extractStsRoleArnAccountId(s3SourceConfig) : (String)this.defaultAwsCredentialsProvider.resolveCredentials().accountId().orElseThrow(() -> new InvalidPluginConfigurationException("The S3 source is unable to determine a bucket owner. Configure the default_bucket_owner for the account Id that owns the bucket. You may also want to configure bucket_owners if you read from S3 buckets in different accounts."))));
        return new StaticBucketOwnerProvider(accountId);
    }

    private String extractQueueAccountId(S3SourceConfig s3SourceConfig) {
        String accountId;
        String queueUrl = s3SourceConfig.getSqsOptions().getSqsUrl();
        try {
            accountId = SqsQueueUrl.parse(queueUrl).getAccountId();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        return accountId;
    }

    private String extractStsRoleArnAccountId(S3SourceConfig s3SourceConfig) {
        return StsArnRole.parse((String)s3SourceConfig.getAwsAuthenticationOptions().getAwsStsRoleArn()).getAccountId();
    }
}

