/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import com.linecorp.armeria.client.retry.Backoff;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.opensearch.dataprepper.common.concurrent.BackgroundThreadFactory;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.plugins.source.s3.S3Service;
import org.opensearch.dataprepper.plugins.source.s3.S3SourceConfig;
import org.opensearch.dataprepper.plugins.source.s3.SqsWorker;
import org.opensearch.dataprepper.plugins.source.sqs.common.SqsBackoff;
import org.opensearch.dataprepper.plugins.source.sqs.common.SqsClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sqs.SqsClient;

public class SqsService {
    private static final Logger LOG = LoggerFactory.getLogger(SqsService.class);
    private final S3SourceConfig s3SourceConfig;
    private final S3Service s3Accessor;
    private final SqsClient sqsClient;
    private final PluginMetrics pluginMetrics;
    private final AcknowledgementSetManager acknowledgementSetManager;
    private final ExecutorService executorService;
    private final List<SqsWorker> sqsWorkers;
    private final Backoff backoff;

    public SqsService(AcknowledgementSetManager acknowledgementSetManager, S3SourceConfig s3SourceConfig, S3Service s3Accessor, PluginMetrics pluginMetrics, AwsCredentialsProvider credentialsProvider) {
        this.s3SourceConfig = s3SourceConfig;
        this.s3Accessor = s3Accessor;
        this.pluginMetrics = pluginMetrics;
        this.acknowledgementSetManager = acknowledgementSetManager;
        this.sqsClient = SqsClientFactory.createSqsClient((Region)s3SourceConfig.getAwsAuthenticationOptions().getAwsRegion(), (AwsCredentialsProvider)credentialsProvider);
        this.executorService = Executors.newFixedThreadPool(s3SourceConfig.getNumWorkers(), (ThreadFactory)BackgroundThreadFactory.defaultExecutorThreadFactory((String)"s3-source-sqs"));
        this.backoff = SqsBackoff.createExponentialBackoff();
        this.sqsWorkers = IntStream.range(0, s3SourceConfig.getNumWorkers()).mapToObj(i -> new SqsWorker(acknowledgementSetManager, this.sqsClient, s3Accessor, s3SourceConfig, pluginMetrics, this.backoff)).collect(Collectors.toList());
    }

    public void start() {
        this.sqsWorkers.forEach(this.executorService::submit);
    }

    public void stop() {
        block3: {
            this.executorService.shutdown();
            this.sqsWorkers.forEach(SqsWorker::stop);
            try {
                if (!this.executorService.awaitTermination(this.s3SourceConfig.getSqsOptions().getShutdownTimeout().getSeconds(), TimeUnit.SECONDS)) {
                    LOG.warn("Failed to terminate SqsWorkers");
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                if (!(e.getCause() instanceof InterruptedException)) break block3;
                LOG.error("Interrupted during shutdown, exiting uncleanly...", (Throwable)e);
                this.executorService.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
        this.sqsClient.close();
    }
}

