/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.termvectors;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Token
implements JsonpSerializable {
    @Nullable
    private final Integer endOffset;
    @Nullable
    private final String payload;
    private final int position;
    @Nullable
    private final Integer startOffset;
    public static final JsonpDeserializer<Token> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Token::setupTokenDeserializer);

    private Token(Builder builder) {
        this.endOffset = builder.endOffset;
        this.payload = builder.payload;
        this.position = ApiTypeHelper.requireNonNull(builder.position, this, "position");
        this.startOffset = builder.startOffset;
    }

    public static Token of(Function<Builder, ObjectBuilder<Token>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer endOffset() {
        return this.endOffset;
    }

    @Nullable
    public final String payload() {
        return this.payload;
    }

    public final int position() {
        return this.position;
    }

    @Nullable
    public final Integer startOffset() {
        return this.startOffset;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.endOffset != null) {
            generator.writeKey("end_offset");
            generator.write(this.endOffset.intValue());
        }
        if (this.payload != null) {
            generator.writeKey("payload");
            generator.write(this.payload);
        }
        generator.writeKey("position");
        generator.write(this.position);
        if (this.startOffset != null) {
            generator.writeKey("start_offset");
            generator.write(this.startOffset.intValue());
        }
    }

    protected static void setupTokenDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::endOffset, JsonpDeserializer.integerDeserializer(), "end_offset");
        op.add(Builder::payload, JsonpDeserializer.stringDeserializer(), "payload");
        op.add(Builder::position, JsonpDeserializer.integerDeserializer(), "position");
        op.add(Builder::startOffset, JsonpDeserializer.integerDeserializer(), "start_offset");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Token> {
        @Nullable
        private Integer endOffset;
        @Nullable
        private String payload;
        private Integer position;
        @Nullable
        private Integer startOffset;

        public final Builder endOffset(@Nullable Integer value) {
            this.endOffset = value;
            return this;
        }

        public final Builder payload(@Nullable String value) {
            this.payload = value;
            return this;
        }

        public final Builder position(int value) {
            this.position = value;
            return this;
        }

        public final Builder startOffset(@Nullable Integer value) {
            this.startOffset = value;
            return this;
        }

        @Override
        public Token build() {
            this._checkSingleUse();
            return new Token(this);
        }
    }
}

