/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.router;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.opensearch.dataprepper.core.parser.DataFlowComponent;
import org.opensearch.dataprepper.core.pipeline.router.RouterGetRecordStrategy;
import org.opensearch.dataprepper.model.record.Record;

class DataFlowComponentRouter {
    static final String DEFAULT_ROUTE = "_default";

    DataFlowComponentRouter() {
    }

    <C> void route(Collection<Record> allRecords, DataFlowComponent<C> dataFlowComponent, Map<Record, Set<String>> recordsToRoutes, RouterGetRecordStrategy getRecordStrategy, BiConsumer<C, Collection<Record>> componentRecordsConsumer) {
        Collection<Record> recordsForComponent;
        Set<String> dataFlowComponentRoutes = dataFlowComponent.getRoutes();
        if (dataFlowComponentRoutes.isEmpty()) {
            recordsForComponent = getRecordStrategy.getAllRecords(allRecords);
        } else {
            recordsForComponent = new ArrayList<Record>();
            for (Record record : allRecords) {
                Set routesForEvent = recordsToRoutes.getOrDefault(record, Collections.emptySet());
                if (routesForEvent.size() == 0 && dataFlowComponentRoutes.contains(DEFAULT_ROUTE)) {
                    recordsForComponent.add(getRecordStrategy.getRecord(record));
                    continue;
                }
                if (!routesForEvent.stream().anyMatch(dataFlowComponentRoutes::contains)) continue;
                recordsForComponent.add(getRecordStrategy.getRecord(record));
            }
        }
        componentRecordsConsumer.accept(dataFlowComponent.getComponent(), recordsForComponent);
    }
}

