/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.Counter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.core.pipeline.Pipeline;
import org.opensearch.dataprepper.core.pipeline.PipelineRunner;
import org.opensearch.dataprepper.core.pipeline.ProcessorProvider;
import org.opensearch.dataprepper.core.pipeline.common.FutureHelper;
import org.opensearch.dataprepper.core.pipeline.common.FutureHelperResult;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.CheckpointState;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.DefaultEventHandle;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineRunnerImpl
implements PipelineRunner {
    private static final Logger LOG = LoggerFactory.getLogger(PipelineRunnerImpl.class);
    private static final String INVALID_EVENT_HANDLES = "invalidEventHandles";
    private boolean isEmptyRecordsLogged = false;
    private final Counter invalidEventHandlesCounter;
    private final Pipeline pipeline;
    private final PluginMetrics pluginMetrics;
    private final ProcessorProvider processorProvider;

    public PipelineRunnerImpl(Pipeline pipeline, ProcessorProvider processorProvider) {
        this.pipeline = pipeline;
        this.pluginMetrics = PluginMetrics.fromNames((String)"PipelineRunner", (String)pipeline.getName());
        this.processorProvider = processorProvider;
        this.invalidEventHandlesCounter = this.pluginMetrics.counter(INVALID_EVENT_HANDLES);
    }

    @Override
    public void runAllProcessorsAndPublishToSinks() {
        Map.Entry<Collection, CheckpointState> recordsReadFromBuffer = this.readFromBuffer(this.getBuffer(), this.getPipeline());
        Collection records = recordsReadFromBuffer.getKey();
        CheckpointState checkpointState = recordsReadFromBuffer.getValue();
        List<Processor> currentProcessors = this.processorProvider.getProcessors();
        records = this.runProcessorsAndProcessAcknowledgements(currentProcessors, records);
        this.postToSink(this.getPipeline(), records);
        this.getBuffer().checkpoint(checkpointState);
    }

    @VisibleForTesting
    Map.Entry<Collection, CheckpointState> readFromBuffer(Buffer buffer, Pipeline pipeline) {
        Map.Entry readResult = buffer.read(pipeline.getReadBatchTimeoutInMillis());
        Collection records = (Collection)readResult.getKey();
        if (records.isEmpty()) {
            if (!this.isEmptyRecordsLogged) {
                LOG.debug(" {} Worker: No records received from buffer", (Object)pipeline.getName());
                this.isEmptyRecordsLogged = true;
            }
        } else {
            LOG.debug(" {} Worker: Processing {} records from buffer", (Object)pipeline.getName(), (Object)records.size());
        }
        return readResult;
    }

    @VisibleForTesting
    void processAcknowledgements(List<Event> inputEvents, Collection<Record<Event>> outputRecords) {
        Set outputEventsSet = outputRecords.stream().map(Record::getData).collect(Collectors.toSet());
        inputEvents.forEach(event -> {
            EventHandle eventHandle = event.getEventHandle();
            if (eventHandle != null && !outputEventsSet.contains(event)) {
                if (eventHandle instanceof DefaultEventHandle) {
                    eventHandle.release(true);
                } else {
                    this.invalidEventHandlesCounter.increment();
                }
            }
        });
    }

    @VisibleForTesting
    Collection runProcessorsAndProcessAcknowledgements(List<Processor> processors, Collection records) {
        for (Processor processor : processors) {
            List<Event> inputEvents = null;
            if (this.getPipeline().areAcknowledgementsEnabled()) {
                inputEvents = ((List)records).stream().map(Record::getData).collect(Collectors.toList());
            }
            try {
                records = processor.execute((Collection)records);
                if (processor.holdsEvents() || inputEvents == null) continue;
                this.processAcknowledgements(inputEvents, records);
            }
            catch (Exception e) {
                if (this.pipeline.getFailurePipeline() != null) {
                    LOG.error("A processor threw an exception. This batch of Events will be sent to DLQ. ", (Throwable)e);
                    this.pipeline.getFailurePipeline().sendEvents(records);
                } else if (inputEvents != null) {
                    LOG.error("A processor threw an exception. This batch of Events will be dropped, and their EventHandles will be released: ", (Throwable)e);
                    this.processAcknowledgements(inputEvents, Collections.emptyList());
                }
                records = Collections.emptyList();
                break;
            }
        }
        return records;
    }

    @VisibleForTesting
    boolean postToSink(Pipeline pipeline, Collection<Record> records) {
        LOG.debug("Pipeline Worker: Submitting {} processed records to sinks", (Object)records.size());
        List sinkFutures = pipeline.publishToSinks(records);
        FutureHelperResult futureResults = FutureHelper.awaitFuturesIndefinitely(sinkFutures);
        return futureResults.getFailedReasons().size() == 0;
    }

    @Override
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    @VisibleForTesting
    Buffer getBuffer() {
        return this.getPipeline().getBuffer();
    }
}

