/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder;

import javax.inject.Named;
import org.opensearch.dataprepper.core.parser.model.DataPrepperConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.DefaultPeerForwarderProvider;
import org.opensearch.dataprepper.core.peerforwarder.LocalModePeerForwarderProvider;
import org.opensearch.dataprepper.core.peerforwarder.PeerClientPool;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderClientFactory;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderConfiguration;
import org.opensearch.dataprepper.core.peerforwarder.PeerForwarderProvider;
import org.opensearch.dataprepper.core.peerforwarder.certificate.CertificateProviderFactory;
import org.opensearch.dataprepper.core.peerforwarder.client.PeerForwarderClient;
import org.opensearch.dataprepper.core.peerforwarder.codec.PeerForwarderCodec;
import org.opensearch.dataprepper.core.peerforwarder.server.PeerForwarderHttpServerProvider;
import org.opensearch.dataprepper.core.peerforwarder.server.PeerForwarderHttpService;
import org.opensearch.dataprepper.core.peerforwarder.server.PeerForwarderServer;
import org.opensearch.dataprepper.core.peerforwarder.server.PeerForwarderServerProxy;
import org.opensearch.dataprepper.core.peerforwarder.server.ResponseHandler;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
class PeerForwarderAppConfig {
    static final String COMPONENT_SCOPE = "core";
    static final String COMPONENT_ID = "peerForwarder";

    PeerForwarderAppConfig() {
    }

    @Bean(name={"peerForwarderMetrics"})
    public PluginMetrics pluginMetrics() {
        return PluginMetrics.fromNames((String)COMPONENT_ID, (String)COMPONENT_SCOPE);
    }

    @Bean
    public PeerForwarderConfiguration peerForwarderConfiguration(@Autowired(required=false) DataPrepperConfiguration dataPrepperConfiguration) {
        if (dataPrepperConfiguration != null && dataPrepperConfiguration.getPeerForwarderConfiguration() != null) {
            return dataPrepperConfiguration.getPeerForwarderConfiguration();
        }
        return new PeerForwarderConfiguration();
    }

    @Bean
    public PeerClientPool peerClientPool() {
        return new PeerClientPool();
    }

    @Bean
    public CertificateProviderFactory certificateProviderFactory(PeerForwarderConfiguration peerForwarderConfiguration) {
        return new CertificateProviderFactory(peerForwarderConfiguration);
    }

    @Bean
    public PeerForwarderClientFactory peerForwarderClientFactory(PeerForwarderConfiguration peerForwarderConfiguration, PeerClientPool peerClientPool, CertificateProviderFactory certificateProviderFactory, @Qualifier(value="peerForwarderMetrics") PluginMetrics pluginMetrics) {
        return new PeerForwarderClientFactory(peerForwarderConfiguration, peerClientPool, certificateProviderFactory, pluginMetrics);
    }

    @Bean
    public PeerForwarderClient peerForwarderClient(PeerForwarderConfiguration peerForwarderConfiguration, PeerForwarderClientFactory peerForwarderClientFactory, PeerForwarderCodec peerForwarderCodec, @Qualifier(value="peerForwarderMetrics") PluginMetrics pluginMetrics) {
        return new PeerForwarderClient(peerForwarderConfiguration, peerForwarderClientFactory, peerForwarderCodec, pluginMetrics);
    }

    @Bean(name={"defaultPeerForwarder"})
    public DefaultPeerForwarderProvider peerForwarderProvider(PeerForwarderClientFactory peerForwarderClientFactory, PeerForwarderClient peerForwarderClient, PeerForwarderConfiguration peerForwarderConfiguration, @Qualifier(value="peerForwarderMetrics") PluginMetrics pluginMetrics) {
        return new DefaultPeerForwarderProvider(peerForwarderClientFactory, peerForwarderClient, peerForwarderConfiguration, pluginMetrics);
    }

    @Bean
    @Primary
    public PeerForwarderProvider peerForwarderProvider(@Named(value="defaultPeerForwarder") PeerForwarderProvider peerForwarderProvider) {
        return new LocalModePeerForwarderProvider(peerForwarderProvider);
    }

    @Bean
    public ResponseHandler responseHandler(@Qualifier(value="peerForwarderMetrics") PluginMetrics pluginMetrics) {
        return new ResponseHandler(pluginMetrics);
    }

    @Bean
    public PeerForwarderHttpService peerForwarderHttpService(ResponseHandler responseHandler, PeerForwarderProvider peerForwarderProvider, PeerForwarderConfiguration peerForwarderConfiguration, PeerForwarderCodec peerForwarderCodec, AcknowledgementSetManager acknowledgementSetManager, @Qualifier(value="peerForwarderMetrics") PluginMetrics pluginMetrics) {
        return new PeerForwarderHttpService(responseHandler, peerForwarderProvider, peerForwarderConfiguration, peerForwarderCodec, acknowledgementSetManager, pluginMetrics);
    }

    @Bean
    public PeerForwarderHttpServerProvider peerForwarderHttpServerProvider(PeerForwarderConfiguration peerForwarderConfiguration, CertificateProviderFactory certificateProviderFactory, PeerForwarderHttpService peerForwarderHttpService) {
        return new PeerForwarderHttpServerProvider(peerForwarderConfiguration, certificateProviderFactory, peerForwarderHttpService);
    }

    @Bean
    public PeerForwarderServer peerForwarderServer(PeerForwarderHttpServerProvider peerForwarderHttpServerProvider, PeerForwarderConfiguration peerForwarderConfiguration, PeerForwarderProvider peerForwarderProvider) {
        return new PeerForwarderServerProxy(peerForwarderHttpServerProvider, peerForwarderConfiguration, peerForwarderProvider);
    }
}

