/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.peerforwarder;

import com.linecorp.armeria.client.Endpoint;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Consumer;
import javax.annotation.concurrent.NotThreadSafe;
import org.opensearch.dataprepper.core.peerforwarder.discovery.PeerListProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HashRing
implements Consumer<List<Endpoint>> {
    private static final Logger LOG = LoggerFactory.getLogger(HashRing.class);
    private static final String MD5 = "MD5";
    private static final String DELIMITER = ",";
    private final int numVirtualNodes;
    private final PeerListProvider peerListProvider;
    private TreeMap<BigInteger, String> hashServerMap = new TreeMap();

    public HashRing(PeerListProvider peerListProvider, int numVirtualNodes) {
        Objects.requireNonNull(peerListProvider);
        this.peerListProvider = peerListProvider;
        this.numVirtualNodes = numVirtualNodes;
        this.buildHashServerMap();
        peerListProvider.addListener(this);
    }

    public Optional<String> getServerIp(List<String> identificationKeyValues) {
        MessageDigest md;
        if (this.hashServerMap.isEmpty()) {
            return Optional.empty();
        }
        byte[] identificationKeysInBytes = String.join((CharSequence)DELIMITER, identificationKeyValues).getBytes();
        try {
            md = MessageDigest.getInstance(MD5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("unreachable", e);
        }
        md.update(identificationKeysInBytes);
        BigInteger hashcode = new BigInteger(md.digest());
        Map.Entry<BigInteger, String> entry = this.hashServerMap.higherEntry(hashcode);
        if (entry == null) {
            return Optional.of(this.hashServerMap.firstEntry().getValue());
        }
        return Optional.of(entry.getValue());
    }

    @Override
    public void accept(List<Endpoint> endpoints) {
        this.buildHashServerMap();
    }

    private void buildHashServerMap() {
        TreeMap<BigInteger, String> newHashValueMap = new TreeMap<BigInteger, String>();
        List<String> endpoints = this.peerListProvider.getPeerList();
        LOG.info("Building hash ring with endpoints: {}", endpoints);
        for (String serverIp : endpoints) {
            this.addServerIpToHashMap(serverIp, newHashValueMap);
        }
        this.hashServerMap = newHashValueMap;
    }

    private void addServerIpToHashMap(String serverIp, Map<BigInteger, String> targetMap) {
        MessageDigest md;
        byte[] serverIpInBytes = serverIp.getBytes();
        try {
            md = MessageDigest.getInstance(MD5);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("unreachable", e);
        }
        ByteBuffer intBuffer = ByteBuffer.allocate(4);
        for (int i = 0; i < this.numVirtualNodes; ++i) {
            md.update(serverIpInBytes);
            intBuffer.putInt(i);
            md.update(intBuffer.array());
            BigInteger hashcode = new BigInteger(md.digest());
            targetMap.putIfAbsent(hashcode, serverIp);
            md.reset();
            intBuffer.clear();
        }
    }
}

