/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.parser.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;

public class SourceCoordinationConfig {
    private static final String SOURCE_COORDINATOR_METRIC_PREFIX = "source-coordinator";
    private final PluginSetting sourceCoordinationStoreConfig;
    private final String partitionPrefix;

    @JsonCreator
    public SourceCoordinationConfig(@JsonProperty(value="store") PluginModel sourceCoordinationStoreConfig, @JsonProperty(value="partition_prefix") String partitionPrefix) {
        Objects.requireNonNull(sourceCoordinationStoreConfig, "source_coordination store must not be null");
        this.sourceCoordinationStoreConfig = new PluginSetting(sourceCoordinationStoreConfig.getPluginName(), sourceCoordinationStoreConfig.getPluginSettings());
        this.sourceCoordinationStoreConfig.setPipelineName(SOURCE_COORDINATOR_METRIC_PREFIX);
        this.partitionPrefix = partitionPrefix;
    }

    public PluginSetting getSourceCoordinationStoreConfig() {
        return this.sourceCoordinationStoreConfig;
    }

    public String getPartitionPrefix() {
        return this.partitionPrefix;
    }
}

