/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.acknowledgements;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.core.acknowledgements.AcknowledgementSetMonitor;
import org.opensearch.dataprepper.core.acknowledgements.AcknowledgementSetMonitorThread;
import org.opensearch.dataprepper.core.acknowledgements.DefaultAcknowledgementSet;
import org.opensearch.dataprepper.core.acknowledgements.DefaultAcknowledgementSetMetrics;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;

@Named
public class DefaultAcknowledgementSetManager
implements AcknowledgementSetManager {
    private static final int DEFAULT_WAIT_TIME_MS = 15000;
    private final AcknowledgementSetMonitor acknowledgementSetMonitor = new AcknowledgementSetMonitor();
    private final ScheduledExecutorService scheduledExecutor;
    private final AcknowledgementSetMonitorThread acknowledgementSetMonitorThread;
    private PluginMetrics pluginMetrics;
    private DefaultAcknowledgementSetMetrics metrics;

    @Inject
    public DefaultAcknowledgementSetManager(@Named(value="acknowledgementCallbackExecutor") ScheduledExecutorService callbackExecutor) {
        this(callbackExecutor, Duration.ofMillis(15000L));
    }

    public DefaultAcknowledgementSetManager(ScheduledExecutorService callbackExecutor, Duration waitTime) {
        this.scheduledExecutor = Objects.requireNonNull(callbackExecutor);
        this.acknowledgementSetMonitorThread = new AcknowledgementSetMonitorThread(this.acknowledgementSetMonitor, waitTime);
        this.acknowledgementSetMonitorThread.start();
        this.pluginMetrics = PluginMetrics.fromNames((String)"acknowledgementSetManager", (String)"acknowledgements");
        this.metrics = new DefaultAcknowledgementSetMetrics(this.pluginMetrics);
    }

    public AcknowledgementSet create(Consumer<Boolean> callback, Duration timeout) {
        DefaultAcknowledgementSet acknowledgementSet = new DefaultAcknowledgementSet(this.scheduledExecutor, callback, timeout, this.metrics);
        this.acknowledgementSetMonitor.add(acknowledgementSet);
        this.metrics.increment("numberOfAcknowledgementSetsCreated");
        return acknowledgementSet;
    }

    public void shutdown() {
        this.acknowledgementSetMonitorThread.stop();
    }

    AcknowledgementSetMonitor getAcknowledgementSetMonitor() {
        return this.acknowledgementSetMonitor;
    }
}

