/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry;

import java.util.List;
import java.util.Optional;
import org.springframework.http.HttpStatus;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public interface RetryStrategy {
    public static final List<Integer> DEFAULT_RETRY_ATTEMPT_SLEEP_TIME = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(10), Integer.valueOf(20), Integer.valueOf(40));
    public static final List<Integer> DEFAULT_RATE_LIMIT_RETRY_SLEEP_TIME = List.of(Integer.valueOf(5), Integer.valueOf(10), Integer.valueOf(30), Integer.valueOf(60), Integer.valueOf(120), Integer.valueOf(300));
    public static final int SLEEP_TIME_MULTIPLIER_MS = 1000;
    public static final int MAX_RETRIES = DEFAULT_RETRY_ATTEMPT_SLEEP_TIME.size();

    public long calculateSleepTime(Exception var1, int var2);

    public int getMaxRetries();

    public static Optional<HttpStatus> getStatusCode(Exception ex) {
        if (ex instanceof HttpClientErrorException) {
            return Optional.of(((HttpClientErrorException)((Object)ex)).getStatusCode());
        }
        if (ex instanceof HttpServerErrorException) {
            return Optional.of(((HttpServerErrorException)((Object)ex)).getStatusCode());
        }
        return Optional.empty();
    }
}

