/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry;

import java.util.function.Supplier;
import org.opensearch.dataprepper.plugins.source.source_crawler.exception.SaaSCrawlerException;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.RetryDecision;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.RetryStrategy;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.StatusCodeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public class RetryHandler {
    private static final Logger log = LoggerFactory.getLogger(RetryHandler.class);
    private final RetryStrategy retryStrategy;
    private final StatusCodeHandler statusCodeHandler;

    public RetryHandler(RetryStrategy retryStrategy, StatusCodeHandler statusCodeHandler) {
        this.retryStrategy = retryStrategy;
        this.statusCodeHandler = statusCodeHandler;
    }

    public <T> T executeWithRetry(Supplier<T> operation, Runnable credentialRenewal) {
        return this.executeWithRetry(operation, credentialRenewal, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeWithRetry(Supplier<T> operation, Runnable credentialRenewal, Runnable failureHandler) {
        if (operation == null) {
            throw new SaaSCrawlerException("Operation cannot be null", false);
        }
        if (credentialRenewal == null) {
            throw new SaaSCrawlerException("Credential renewal cannot be null", false);
        }
        int maxRetries = this.retryStrategy.getMaxRetries();
        for (int retryCount = 0; retryCount < maxRetries; ++retryCount) {
            boolean operationSucceeded = false;
            try {
                T result = operation.get();
                operationSucceeded = true;
                T t = result;
                return t;
            }
            catch (HttpClientErrorException | HttpServerErrorException ex) {
                RetryDecision decision = this.statusCodeHandler.handleStatusCode((Exception)ex, retryCount, credentialRenewal);
                if (decision.isShouldStop()) {
                    decision.getException().ifPresent(e -> {
                        throw new SecurityException("Access forbidden: " + e.getMessage());
                    });
                    throw ex;
                }
                if (retryCount == maxRetries - 1) {
                    log.error("Exceeded maximum retry attempts ({})", (Object)maxRetries, (Object)ex);
                    throw ex;
                }
                long sleepTimeMs = this.retryStrategy.calculateSleepTime((Exception)ex, retryCount);
                this.sleep(sleepTimeMs);
                continue;
            }
            finally {
                if (!operationSucceeded && failureHandler != null) {
                    failureHandler.run();
                }
            }
        }
        throw new RuntimeException("Exceeded maximum retry attempts (" + maxRetries + ")");
    }

    private void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Retry interrupted", ie);
        }
    }
}

