/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.RetryStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class DefaultRetryStrategy
implements RetryStrategy {
    private static final Logger log = LoggerFactory.getLogger(DefaultRetryStrategy.class);
    private static final List<HttpStatus> DEFAULT_RATE_LIMIT_STATUS_CODES = Arrays.asList(HttpStatus.TOO_MANY_REQUESTS);
    private final List<Integer> retryAttemptSleepTime = RetryStrategy.DEFAULT_RETRY_ATTEMPT_SLEEP_TIME;
    private final List<Integer> rateLimitRetrySleepTime;
    private final List<HttpStatus> rateLimitStatusCodes;
    private final int maxRetries;

    public DefaultRetryStrategy() {
        this.rateLimitRetrySleepTime = RetryStrategy.DEFAULT_RATE_LIMIT_RETRY_SLEEP_TIME;
        this.rateLimitStatusCodes = DEFAULT_RATE_LIMIT_STATUS_CODES;
        this.maxRetries = RetryStrategy.MAX_RETRIES;
    }

    public DefaultRetryStrategy(int maxRetries) {
        this.rateLimitRetrySleepTime = RetryStrategy.DEFAULT_RATE_LIMIT_RETRY_SLEEP_TIME;
        this.rateLimitStatusCodes = DEFAULT_RATE_LIMIT_STATUS_CODES;
        this.maxRetries = maxRetries;
    }

    public DefaultRetryStrategy(List<Integer> rateLimitRetrySleepTime, List<HttpStatus> rateLimitStatusCodes) {
        this.rateLimitRetrySleepTime = rateLimitRetrySleepTime != null ? rateLimitRetrySleepTime : RetryStrategy.DEFAULT_RATE_LIMIT_RETRY_SLEEP_TIME;
        this.rateLimitStatusCodes = rateLimitStatusCodes != null ? rateLimitStatusCodes : DEFAULT_RATE_LIMIT_STATUS_CODES;
        this.maxRetries = this.rateLimitRetrySleepTime.size();
    }

    @Override
    public long calculateSleepTime(Exception ex, int retryCount) {
        Optional<HttpStatus> statusCode = RetryStrategy.getStatusCode(ex);
        List<Integer> sleepTimes = statusCode.isPresent() && this.rateLimitStatusCodes.contains(statusCode.get()) ? this.rateLimitRetrySleepTime : this.retryAttemptSleepTime;
        int sleepTimeSeconds = retryCount < sleepTimes.size() ? sleepTimes.get(retryCount) : sleepTimes.get(sleepTimes.size() - 1);
        log.debug("Retrying in {} seconds (attempt {}/{})", new Object[]{sleepTimeSeconds, retryCount + 1, this.getMaxRetries()});
        return sleepTimeSeconds * 1000;
    }

    @Override
    public int getMaxRetries() {
        return this.maxRetries;
    }
}

