/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.utils;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;

public class MetricsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MetricsHelper.class);
    private static final String REQUEST_ACCESS_DENIED = "requestAccessDenied";
    private static final String REQUEST_THROTTLED = "requestThrottled";
    private static final String RESOURCE_NOT_FOUND = "resourceNotFound";
    private static final String GET_REQUESTS_FAILED = "getRequestsFailed";
    private static final String GET_REQUESTS_SUCCESS = "getRequestsSuccess";
    private static final String GET_RESPONSE_SIZE = "getResponseSizeBytes";
    private static final String SEARCH_REQUESTS_FAILED = "searchRequestsFailed";
    private static final String SEARCH_REQUESTS_SUCCESS = "searchRequestsSuccess";
    private static final String SEARCH_RESPONSE_SIZE = "searchResponseSizeBytes";
    public static final String REQUEST_ERRORS = "requestErrors";

    public static Map<String, Counter> getErrorTypeMetricCounterMap(PluginMetrics pluginMetrics) {
        HashMap<String, Counter> errorTypeMetricCounterMap = new HashMap<String, Counter>();
        errorTypeMetricCounterMap.put(HttpStatus.FORBIDDEN.getReasonPhrase(), pluginMetrics.counter(REQUEST_ACCESS_DENIED));
        errorTypeMetricCounterMap.put(HttpStatus.UNAUTHORIZED.getReasonPhrase(), pluginMetrics.counter(REQUEST_ACCESS_DENIED));
        errorTypeMetricCounterMap.put(HttpStatus.TOO_MANY_REQUESTS.getReasonPhrase(), pluginMetrics.counter(REQUEST_THROTTLED));
        errorTypeMetricCounterMap.put(HttpStatus.NOT_FOUND.getReasonPhrase(), pluginMetrics.counter(RESOURCE_NOT_FOUND));
        return errorTypeMetricCounterMap;
    }

    public static void publishErrorTypeMetricCounter(Exception ex, Map<String, Counter> errorTypeMetricCounterMap) {
        HttpClientErrorException httpE;
        Optional<Object> statusCode = Optional.empty();
        if (ex instanceof HttpClientErrorException) {
            httpE = (HttpClientErrorException)ex;
            statusCode = Optional.ofNullable(httpE.getStatusCode().getReasonPhrase());
        } else if (ex instanceof HttpServerErrorException) {
            httpE = (HttpServerErrorException)ex;
            statusCode = Optional.ofNullable(httpE.getStatusCode().getReasonPhrase());
        } else if (ex instanceof SecurityException) {
            statusCode = Optional.ofNullable(HttpStatus.FORBIDDEN.getReasonPhrase());
        }
        if (statusCode.isPresent()) {
            String errorType = (String)statusCode.get();
            if (errorTypeMetricCounterMap != null && errorTypeMetricCounterMap.containsKey(errorType)) {
                errorTypeMetricCounterMap.get(errorType).increment();
            }
        }
    }

    public static void publishSearchResponseSizeMetricInBytes(PluginMetrics pluginMetrics, ResponseEntity<?> response) {
        DistributionSummary summary = pluginMetrics.summary(SEARCH_RESPONSE_SIZE);
        if (response != null && response.getBody() != null) {
            summary.record((double)response.getHeaders().getContentLength());
        } else {
            LOG.error("Response or response body is null when recording API response size metric");
            summary.record(-1.0);
        }
    }

    public static void publishSearchResponseSizeMetricInBytes(PluginMetrics pluginMetrics, String response) {
        DistributionSummary summary = pluginMetrics.summary(SEARCH_RESPONSE_SIZE);
        if (response != null) {
            summary.record((double)response.getBytes(StandardCharsets.UTF_8).length);
        } else {
            LOG.error("Response is null when recording API response size metric");
            summary.record(-1.0);
        }
    }

    public static void publishSearchRequestsSuccessMetric(PluginMetrics pluginMetrics) {
        Counter successCounter = pluginMetrics.counter(SEARCH_REQUESTS_SUCCESS);
        successCounter.increment();
    }

    public static Counter provideSearchRequestFailureCounter(PluginMetrics pluginMetrics) {
        Counter failureCounter = pluginMetrics.counter(SEARCH_REQUESTS_FAILED);
        return failureCounter;
    }

    public static void publishGetResponseSizeMetricInBytes(PluginMetrics pluginMetrics, ResponseEntity<?> response) {
        DistributionSummary summary = pluginMetrics.summary(GET_RESPONSE_SIZE);
        if (response != null && response.getBody() != null) {
            summary.record((double)response.getHeaders().getContentLength());
        } else {
            LOG.error("Response or response body is null when recording GET request response size metric");
            summary.record(-1.0);
        }
    }

    public static void publishGetResponseSizeMetricInBytes(PluginMetrics pluginMetrics, String response) {
        DistributionSummary summary = pluginMetrics.summary(GET_RESPONSE_SIZE);
        if (response != null) {
            summary.record((double)response.getBytes(StandardCharsets.UTF_8).length);
        } else {
            LOG.error("Response is null when recording GET request response size metric");
            summary.record(-1.0);
        }
    }

    public static void publishGetRequestsSuccessMetric(PluginMetrics pluginMetrics) {
        Counter successCounter = pluginMetrics.counter(GET_REQUESTS_SUCCESS);
        successCounter.increment();
    }

    public static Counter provideGetRequestsFailureCounter(PluginMetrics pluginMetrics) {
        Counter failureCounter = pluginMetrics.counter(GET_REQUESTS_FAILED);
        return failureCounter;
    }
}

