/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.base;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class PluginExecutorServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(PluginExecutorServiceProvider.class);
    private static final int DEFAULT_THREAD_COUNT = 50;
    private final ExecutorService executorService;

    public PluginExecutorServiceProvider() {
        this.executorService = Executors.newFixedThreadPool(50);
    }

    public PluginExecutorServiceProvider(ExecutorService testExecutorService) {
        this.executorService = testExecutorService;
    }

    public ExecutorService get() {
        return this.executorService;
    }

    @PreDestroy
    public void terminateExecutor() {
        try {
            log.debug("Shutting down ExecutorService " + String.valueOf(this.executorService));
            this.executorService.shutdown();
            boolean isExecutorTerminated = this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
            log.debug("ExecutorService terminated : " + isExecutorTerminated);
        }
        catch (InterruptedException e) {
            log.error("Interrupted while terminating executor : " + e.getMessage());
            Thread.currentThread().interrupt();
        }
        finally {
            this.executorService.shutdownNow();
        }
    }
}

