/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.otelmetrics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.Exemplar;
import io.opentelemetry.proto.metrics.v1.ExponentialHistogramDataPoint;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.opensearch.dataprepper.model.metric.Bucket;
import org.opensearch.dataprepper.model.metric.DefaultBucket;
import org.opensearch.dataprepper.model.metric.DefaultExemplar;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OTelMetricsProtoHelper {
    private static final Logger LOG = LoggerFactory.getLogger(OTelMetricsProtoHelper.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    static final String EXEMPLAR_ATTRIBUTES = "exemplar.attributes";
    private static final String DOT = ".";
    private static final String AT = "@";
    public static final Function<String, String> REPLACE_DOT_WITH_AT = i -> i.replace(DOT, AT);
    public static final Function<String, String> PREFIX_AND_EXEMPLAR_ATTRIBUTES_REPLACE_DOT_WITH_AT = i -> "exemplar.attributes." + i.replace(DOT, AT);
    private static final Map<Integer, double[]> EXPONENTIAL_BUCKET_BOUNDS = new ConcurrentHashMap<Integer, double[]>();

    private OTelMetricsProtoHelper() {
    }

    public static Object convertAnyValue(AnyValue value) {
        switch (value.getValueCase()) {
            case VALUE_NOT_SET: 
            case STRING_VALUE: {
                return value.getStringValue();
            }
            case BOOL_VALUE: {
                return value.getBoolValue();
            }
            case INT_VALUE: {
                return value.getIntValue();
            }
            case DOUBLE_VALUE: {
                return value.getDoubleValue();
            }
            case ARRAY_VALUE: {
                try {
                    return OBJECT_MAPPER.writeValueAsString(value.getArrayValue().getValuesList().stream().map(OTelMetricsProtoHelper::convertAnyValue).collect(Collectors.toList()));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            case KVLIST_VALUE: {
                try {
                    return OBJECT_MAPPER.writeValueAsString(value.getKvlistValue().getValuesList().stream().collect(Collectors.toMap(i -> REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> OTelMetricsProtoHelper.convertAnyValue(i.getValue()))));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        throw new RuntimeException(String.format("Can not convert AnyValue of type %s", value.getValueCase()));
    }

    public static Map<String, Object> unpackExemplarValueList(List<KeyValue> attributesList) {
        return attributesList.stream().collect(Collectors.toMap(i -> PREFIX_AND_EXEMPLAR_ATTRIBUTES_REPLACE_DOT_WITH_AT.apply(i.getKey()), i -> OTelMetricsProtoHelper.convertAnyValue(i.getValue())));
    }

    public static Double getValueAsDouble(NumberDataPoint ndp) {
        NumberDataPoint.ValueCase ndpCase = ndp.getValueCase();
        if (NumberDataPoint.ValueCase.AS_DOUBLE == ndpCase) {
            return ndp.getAsDouble();
        }
        if (NumberDataPoint.ValueCase.AS_INT == ndpCase) {
            return ndp.getAsInt();
        }
        return null;
    }

    public static Double getExemplarValueAsDouble(Exemplar exemplar) {
        Exemplar.ValueCase valueCase = exemplar.getValueCase();
        if (Exemplar.ValueCase.AS_DOUBLE == valueCase) {
            return exemplar.getAsDouble();
        }
        if (Exemplar.ValueCase.AS_INT == valueCase) {
            return exemplar.getAsInt();
        }
        return null;
    }

    public static String convertUnixNanosToISO8601(long unixNano) {
        return Instant.ofEpochSecond(0L, unixNano).toString();
    }

    public static List<Bucket> createBuckets(List<Long> bucketCountsList, List<Double> explicitBoundsList) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        if (bucketCountsList.isEmpty()) {
            return buckets;
        }
        if (bucketCountsList.size() - 1 != explicitBoundsList.size()) {
            LOG.error("bucket count list not equals to bounds list {} {}", (Object)bucketCountsList.size(), (Object)explicitBoundsList.size());
            throw new IllegalArgumentException("OpenTelemetry protocol mandates that the number of elements in bucket_counts array must be by one greater than\n  // the number of elements in explicit_bounds array.");
        }
        for (int i = 0; i < bucketCountsList.size(); ++i) {
            Long bucketCount;
            double max;
            double min;
            if (i == 0) {
                min = -3.4028234663852886E38;
                max = explicitBoundsList.get(i);
                bucketCount = bucketCountsList.get(i);
                buckets.add((Bucket)new DefaultBucket(Double.valueOf(min), Double.valueOf(max), bucketCount));
                continue;
            }
            if (i == bucketCountsList.size() - 1) {
                min = explicitBoundsList.get(i - 1);
                max = 3.4028234663852886E38;
                bucketCount = bucketCountsList.get(i);
                buckets.add((Bucket)new DefaultBucket(Double.valueOf(min), Double.valueOf(max), bucketCount));
                continue;
            }
            min = explicitBoundsList.get(i - 1);
            max = explicitBoundsList.get(i);
            bucketCount = bucketCountsList.get(i);
            buckets.add((Bucket)new DefaultBucket(Double.valueOf(min), Double.valueOf(max), bucketCount));
        }
        return buckets;
    }

    public static List<org.opensearch.dataprepper.model.metric.Exemplar> convertExemplars(List<Exemplar> exemplarsList) {
        return exemplarsList.stream().map(exemplar -> new DefaultExemplar(OTelMetricsProtoHelper.convertUnixNanosToISO8601(exemplar.getTimeUnixNano()), OTelMetricsProtoHelper.getExemplarValueAsDouble(exemplar), Hex.encodeHexString((byte[])exemplar.getSpanId().toByteArray()), Hex.encodeHexString((byte[])exemplar.getTraceId().toByteArray()), OTelMetricsProtoHelper.unpackExemplarValueList(exemplar.getFilteredAttributesList()))).collect(Collectors.toList());
    }

    static double[] calculateBoundaries(int scale) {
        int len = 1 << Math.abs(scale);
        double[] boundaries = new double[len + 1];
        for (int i = 0; i <= len; ++i) {
            boundaries[i] = scale >= 0 ? Math.pow(2.0, (double)i / (double)len) : Math.pow(2.0, Math.pow(2.0, i));
        }
        return boundaries;
    }

    public static List<Bucket> createExponentialBuckets(ExponentialHistogramDataPoint.Buckets buckets, int scale) {
        double[] bucketBounds = EXPONENTIAL_BUCKET_BOUNDS.computeIfAbsent(scale, integer -> OTelMetricsProtoHelper.calculateBoundaries(scale));
        ArrayList<Bucket> mappedBuckets = new ArrayList<Bucket>();
        int offset = buckets.getOffset();
        List bucketsList = buckets.getBucketCountsList();
        for (int i = 0; i < bucketsList.size(); ++i) {
            Long value = (Long)bucketsList.get(i);
            double lowerBound = bucketBounds[offset + i];
            double upperBound = bucketBounds[offset + i + 1];
            mappedBuckets.add((Bucket)new DefaultBucket(Double.valueOf(lowerBound), Double.valueOf(upperBound), value));
        }
        return mappedBuckets;
    }
}

