/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.stream;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.network.SSLMode;
import java.util.NoSuchElementException;
import org.opensearch.dataprepper.plugins.source.rds.RdsSourceConfig;
import org.opensearch.dataprepper.plugins.source.rds.coordination.partition.StreamPartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.state.PostgresStreamState;
import org.opensearch.dataprepper.plugins.source.rds.model.DbMetadata;
import org.opensearch.dataprepper.plugins.source.rds.schema.ConnectionManager;
import org.opensearch.dataprepper.plugins.source.rds.schema.ConnectionManagerFactory;
import org.opensearch.dataprepper.plugins.source.rds.stream.BinlogClientWrapper;
import org.opensearch.dataprepper.plugins.source.rds.stream.LogicalReplicationClient;
import org.opensearch.dataprepper.plugins.source.rds.stream.ReplicationLogClient;
import org.opensearch.dataprepper.plugins.source.rds.utils.RdsSourceAggregateMetrics;
import software.amazon.awssdk.services.rds.RdsClient;

public class ReplicationLogClientFactory {
    private final RdsClient rdsClient;
    private final DbMetadata dbMetadata;
    private final RdsSourceAggregateMetrics rdsSourceAggregateMetrics;
    private RdsSourceConfig sourceConfig;
    private String username;
    private String password;
    private SSLMode sslMode = SSLMode.REQUIRED;

    public ReplicationLogClientFactory(RdsSourceConfig sourceConfig, RdsClient rdsClient, DbMetadata dbMetadata, RdsSourceAggregateMetrics rdsSourceAggregateMetrics) {
        this.sourceConfig = sourceConfig;
        this.rdsClient = rdsClient;
        this.dbMetadata = dbMetadata;
        this.rdsSourceAggregateMetrics = rdsSourceAggregateMetrics;
        this.username = sourceConfig.getAuthenticationConfig().getUsername();
        this.password = sourceConfig.getAuthenticationConfig().getPassword();
    }

    public ReplicationLogClient create(StreamPartition streamPartition) {
        if (this.sourceConfig.getEngine().isMySql()) {
            return new BinlogClientWrapper(this.createBinaryLogClient(), this.rdsSourceAggregateMetrics);
        }
        return this.createLogicalReplicationClient(streamPartition);
    }

    private BinaryLogClient createBinaryLogClient() {
        BinaryLogClient binaryLogClient = new BinaryLogClient(this.dbMetadata.getEndpoint(), this.dbMetadata.getPort(), this.username, this.password);
        binaryLogClient.setSSLMode(this.sslMode);
        EventDeserializer eventDeserializer = new EventDeserializer();
        eventDeserializer.setCompatibilityMode(EventDeserializer.CompatibilityMode.DATE_AND_TIME_AS_LONG, new EventDeserializer.CompatibilityMode[0]);
        binaryLogClient.setEventDeserializer(eventDeserializer);
        return binaryLogClient;
    }

    private LogicalReplicationClient createLogicalReplicationClient(StreamPartition streamPartition) {
        PostgresStreamState postgresStreamState = streamPartition.getProgressState().get().getPostgresStreamState();
        String publicationName = postgresStreamState.getPublicationName();
        String replicationSlotName = postgresStreamState.getReplicationSlotName();
        if (replicationSlotName == null) {
            throw new NoSuchElementException("Replication slot name is not found in progress state.");
        }
        ConnectionManagerFactory connectionManagerFactory = new ConnectionManagerFactory(this.sourceConfig, this.dbMetadata);
        ConnectionManager connectionManager = connectionManagerFactory.getConnectionManager();
        return new LogicalReplicationClient(connectionManager, publicationName, replicationSlotName, this.rdsSourceAggregateMetrics);
    }

    public void setSSLMode(SSLMode sslMode) {
        this.sslMode = sslMode;
    }

    public void updateCredentials(RdsSourceConfig sourceConfig) {
        this.sourceConfig = sourceConfig;
        this.username = sourceConfig.getAuthenticationConfig().getUsername();
        this.password = sourceConfig.getAuthenticationConfig().getPassword();
    }
}

