/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.handler;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.PostgresDataType;
import org.opensearch.dataprepper.plugins.source.rds.datatype.postgres.PostgresDataTypeHandler;
import org.opensearch.dataprepper.plugins.source.rds.utils.PgArrayParser;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;

public class SpatialTypeHandler
implements PostgresDataTypeHandler {
    @Override
    public Object handle(PostgresDataType columnType, String columnName, Object value) {
        if (!columnType.isSpatial()) {
            throw new IllegalArgumentException("ColumnType is not spatial: " + String.valueOf((Object)columnType));
        }
        if (columnType.isSubCategoryArray()) {
            return PgArrayParser.parseTypedArray(value.toString(), PostgresDataType.getScalarType(columnType), this::parseGeometry);
        }
        return this.parseGeometry(columnType, value.toString());
    }

    private Object parseGeometry(PostgresDataType columnType, String val) {
        switch (columnType) {
            case POINT: {
                return this.parsePoint(val);
            }
            case LINE: {
                return this.parseLine(val);
            }
            case LSEG: {
                return this.parseLseg(val);
            }
            case BOX: {
                return this.parseBox(val);
            }
            case PATH: {
                return this.parsePath(val);
            }
            case POLYGON: {
                return this.parsePolygon(val);
            }
            case CIRCLE: {
                return this.parseCircle(val);
            }
        }
        return val;
    }

    private String parsePoint(String val) {
        try {
            PGpoint point = new PGpoint(val);
            return String.format("POINT(%f %f)", point.x, point.y);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error converting String to PGpoint object", e);
        }
    }

    private String parseLine(String val) {
        try {
            PGline line = new PGline(val);
            PGpoint[] points = this.getPointsOnLine(line);
            return this.formatLine(points);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error converting String to PGpoint object", e);
        }
    }

    private String parseLseg(String val) {
        try {
            PGlseg lseg = new PGlseg(val);
            PGpoint[] points = lseg.point;
            if (points == null || points.length != 2) {
                throw new IllegalArgumentException("LineSegment must have at least 2 points");
            }
            return this.formatLine(points);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error converting String to PGlseg object", e);
        }
    }

    private String parseBox(String val) {
        try {
            PGbox box = new PGbox(val);
            PGpoint[] points = box.point;
            if (points == null || points.length != 2) {
                throw new IllegalArgumentException("Box must have exactly 2 points");
            }
            return this.formatBox(points);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error converting String to PGbox object", e);
        }
    }

    private String parsePath(String val) {
        try {
            PGpath path = new PGpath(val);
            PGpoint[] points = path.points;
            if (points == null || points.length == 0) {
                throw new IllegalArgumentException("Path must have at least 1 point");
            }
            return this.formatPath(points, path.open);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error converting String to PGpath object", e);
        }
    }

    private Object parseCircle(String val) {
        try {
            PGcircle circle = new PGcircle(val);
            if (circle.center == null) {
                throw new IllegalArgumentException("Circle must have a center point");
            }
            return this.formatCircle(circle);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error converting String to PGcircle object", e);
        }
    }

    private String parsePolygon(String val) {
        try {
            PGpolygon polygon = new PGpolygon(val);
            PGpoint[] points = polygon.points;
            if (points == null || points.length == 0) {
                throw new IllegalArgumentException("Path must have at least 1 point");
            }
            return this.formatPolygon(points);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error converting String to PGpolygon object", e);
        }
    }

    private PGpoint[] getPointsOnLine(PGline line) {
        PGpoint p2;
        PGpoint p1;
        double a = line.a;
        double b = line.b;
        double c = line.c;
        if (b != 0.0) {
            double x1 = 0.0;
            double y1 = -c / b;
            double x2 = 1.0;
            double y2 = -(c + a) / b;
            p1 = new PGpoint(x1, y1);
            p2 = new PGpoint(x2, y2);
        } else if (a != 0.0) {
            double y1 = 0.0;
            double x1 = -c / a;
            double y2 = 1.0;
            double x2 = -(c + b) / a;
            p1 = new PGpoint(x1, y1);
            p2 = new PGpoint(x2, y2);
        } else {
            throw new IllegalArgumentException("Invalid line: both a and b cannot be zero");
        }
        return new PGpoint[]{p1, p2};
    }

    private static String formatPoint(PGpoint p) {
        return String.format("%f %f", p.x, p.y);
    }

    private void appendPoints(StringBuilder wkt, PGpoint[] points) {
        for (int i = 0; i < points.length; ++i) {
            if (i > 0) {
                wkt.append(", ");
            }
            wkt.append(SpatialTypeHandler.formatPoint(points[i]));
        }
    }

    private String formatLine(PGpoint[] points) {
        StringBuilder wkt = new StringBuilder("LINESTRING(");
        this.appendPoints(wkt, points);
        wkt.append(")");
        return wkt.toString();
    }

    private String formatBox(PGpoint[] points) {
        StringBuilder wkt = new StringBuilder("POLYGON((");
        this.appendPoints(wkt, new PGpoint[]{points[0], new PGpoint(points[1].x, points[0].y), points[1], new PGpoint(points[0].x, points[1].y), points[0]});
        wkt.append("))");
        return wkt.toString();
    }

    private String formatPath(PGpoint[] points, boolean isOpenPath) {
        StringBuilder wkt = new StringBuilder();
        wkt.append(isOpenPath ? "LINESTRING(" : "POLYGON((");
        this.appendPoints(wkt, points);
        if (!isOpenPath && !points[0].equals((Object)points[points.length - 1])) {
            wkt.append(", ").append(SpatialTypeHandler.formatPoint(points[0]));
        }
        wkt.append(isOpenPath ? ")" : "))");
        return wkt.toString();
    }

    private String formatPolygon(PGpoint[] points) {
        StringBuilder wkt = new StringBuilder("POLYGON((");
        this.appendPoints(wkt, points);
        if (!points[0].equals((Object)points[points.length - 1])) {
            wkt.append(", ").append(SpatialTypeHandler.formatPoint(points[0]));
        }
        wkt.append("))");
        return wkt.toString();
    }

    private Object formatCircle(PGcircle circle) {
        PGpoint center = circle.center;
        HashMap<String, Object> circleObject = new HashMap<String, Object>();
        circleObject.put("center", Map.of("x", center.x, "y", center.y));
        circleObject.put("radius", circle.radius);
        return circleObject;
    }
}

