/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.codec.parquet;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.commons.text.StringEscapeUtils;

public class GenericRecordJsonEncoder {
    Map<LogicalType, Function<Object, Object>> logicalTypesConverters = new HashMap<LogicalType, Function<Object, Object>>();
    private static final String TOSTRING_CIRCULAR_REFERENCE_ERROR_TEXT = " \">>> CIRCULAR REFERENCE CANNOT BE PUT IN JSON STRING, ABORTING RECURSION <<<\" ";

    public void registerLogicalTypeConverter(LogicalType logicalType, Function<Object, Object> converter) {
        this.logicalTypesConverters.put(logicalType, converter);
    }

    public Function<Object, Object> getLogicalTypeConverter(Schema.Field field) {
        Schema fieldSchema = field.schema();
        LogicalType logicalType = fieldSchema.getLogicalType();
        return this.getLogicalTypeConverter(logicalType);
    }

    public Function<Object, Object> getLogicalTypeConverter(LogicalType logicalType) {
        if (logicalType == null) {
            return Function.identity();
        }
        return this.logicalTypesConverters.getOrDefault(logicalType, Function.identity());
    }

    public String serialize(GenericRecord value) {
        StringBuilder buffer = new StringBuilder();
        this.serialize(value, buffer, new IdentityHashMap<Object, Object>(128), null);
        String result = buffer.toString();
        return result;
    }

    private void serialize(Object datum, StringBuilder buffer, IdentityHashMap<Object, Object> seenObjects, Integer decimalScale) {
        if (this.isRecord(datum)) {
            if (seenObjects.containsKey(datum)) {
                buffer.append(TOSTRING_CIRCULAR_REFERENCE_ERROR_TEXT);
                return;
            }
            seenObjects.put(datum, datum);
            buffer.append("{");
            int count = 0;
            Schema schema = this.getRecordSchema(datum);
            for (Schema.Field f : schema.getFields()) {
                this.serialize(f.name(), buffer, seenObjects, null);
                buffer.append(": ");
                Function<Object, Object> logicalTypeConverter = this.getLogicalTypeConverter(f);
                boolean serializedDecimal = false;
                Schema fieldSchema = f.schema();
                if (fieldSchema.getType() == Schema.Type.UNION) {
                    for (Schema s : fieldSchema.getTypes()) {
                        if (s.getType() == Schema.Type.NULL || s.getType() != Schema.Type.BYTES && s.getType() != Schema.Type.FIXED || !(s.getLogicalType() instanceof LogicalTypes.Decimal)) continue;
                        this.serialize(logicalTypeConverter.apply(this.getField(datum, f.name(), f.pos())), buffer, seenObjects, ((LogicalTypes.Decimal)s.getLogicalType()).getScale());
                        serializedDecimal = true;
                        break;
                    }
                } else if (fieldSchema.getLogicalType() instanceof LogicalTypes.Decimal) {
                    this.serialize(logicalTypeConverter.apply(this.getField(datum, f.name(), f.pos())), buffer, seenObjects, ((LogicalTypes.Decimal)fieldSchema.getLogicalType()).getScale());
                    serializedDecimal = true;
                }
                if (!serializedDecimal) {
                    this.serialize(logicalTypeConverter.apply(this.getField(datum, f.name(), f.pos())), buffer, seenObjects, null);
                }
                if (++count >= schema.getFields().size()) continue;
                buffer.append(", ");
            }
            buffer.append("}");
            seenObjects.remove(datum);
        } else if (this.isArray(datum)) {
            if (seenObjects.containsKey(datum)) {
                buffer.append(TOSTRING_CIRCULAR_REFERENCE_ERROR_TEXT);
                return;
            }
            seenObjects.put(datum, datum);
            Collection array = this.getArrayAsCollection(datum);
            buffer.append("[");
            long last = array.size() - 1;
            int i = 0;
            for (Object element : array) {
                this.serialize(element, buffer, seenObjects, null);
                if ((long)i++ >= last) continue;
                buffer.append(", ");
            }
            buffer.append("]");
            seenObjects.remove(datum);
        } else if (this.isMap(datum)) {
            if (seenObjects.containsKey(datum)) {
                buffer.append(TOSTRING_CIRCULAR_REFERENCE_ERROR_TEXT);
                return;
            }
            seenObjects.put(datum, datum);
            buffer.append("{");
            int count = 0;
            Map map = (Map)datum;
            for (Map.Entry entry : map.entrySet()) {
                this.serialize(entry.getKey(), buffer, seenObjects, null);
                buffer.append(": ");
                this.serialize(entry.getValue(), buffer, seenObjects, null);
                if (++count >= map.size()) continue;
                buffer.append(", ");
            }
            buffer.append("}");
            seenObjects.remove(datum);
        } else if (this.isString(datum) || this.isEnum(datum)) {
            buffer.append("\"");
            this.writeEscapedString(datum.toString(), buffer);
            buffer.append("\"");
        } else if (this.isBytes(datum)) {
            if (decimalScale != null) {
                ByteBuffer sourceBuffer = (ByteBuffer)datum;
                byte[] bytesArray = new byte[sourceBuffer.remaining()];
                sourceBuffer.duplicate().get(bytesArray);
                BigInteger unscaledValue = new BigInteger(bytesArray);
                BigDecimal decimal = new BigDecimal(unscaledValue, decimalScale);
                buffer.append(decimal.doubleValue());
            } else {
                String bytesAsString = StandardCharsets.UTF_8.decode((ByteBuffer)datum).toString();
                Optional<BigDecimal> bytesAsBigDecimal = this.getBigDecimal(bytesAsString);
                if (bytesAsBigDecimal.isPresent()) {
                    buffer.append(bytesAsBigDecimal.get().doubleValue());
                } else {
                    buffer.append("{\"bytes\": \"");
                    ByteBuffer bytes = ((ByteBuffer)datum).duplicate();
                    this.writeEscapedString(new String(bytes.array(), StandardCharsets.ISO_8859_1), buffer);
                    buffer.append("\"}");
                }
            }
        } else if (datum instanceof Float && (((Float)datum).isInfinite() || ((Float)datum).isNaN()) || datum instanceof Double && (((Double)datum).isInfinite() || ((Double)datum).isNaN())) {
            buffer.append("\"");
            buffer.append(datum);
            buffer.append("\"");
        } else if (datum instanceof GenericFixed) {
            GenericFixed fixed = (GenericFixed)datum;
            byte[] bytes = fixed.bytes();
            if (decimalScale != null) {
                BigInteger unscaledValue = new BigInteger(bytes);
                BigDecimal decimal = new BigDecimal(unscaledValue, decimalScale);
                buffer.append(decimal.toString());
            } else {
                buffer.append("{\"bytes\": \"");
                this.writeEscapedString(new String(bytes, StandardCharsets.ISO_8859_1), buffer);
                buffer.append("\"}");
            }
        } else if (datum instanceof GenericData) {
            if (seenObjects.containsKey(datum)) {
                buffer.append(TOSTRING_CIRCULAR_REFERENCE_ERROR_TEXT);
                return;
            }
            seenObjects.put(datum, datum);
            this.serialize(datum, buffer, seenObjects, null);
            seenObjects.remove(datum);
        } else {
            buffer.append(datum);
        }
    }

    private boolean isRecord(Object datum) {
        return datum instanceof IndexedRecord;
    }

    private Schema getRecordSchema(Object record) {
        return ((GenericContainer)record).getSchema();
    }

    private Object getField(Object record, String name, int position) {
        return ((IndexedRecord)record).get(position);
    }

    private boolean isArray(Object datum) {
        return datum instanceof Collection;
    }

    private Collection getArrayAsCollection(Object datum) {
        return (Collection)datum;
    }

    private boolean isEnum(Object datum) {
        return datum instanceof GenericEnumSymbol;
    }

    private boolean isMap(Object datum) {
        return datum instanceof Map;
    }

    private boolean isString(Object datum) {
        return datum instanceof CharSequence;
    }

    private boolean isBytes(Object datum) {
        return datum instanceof ByteBuffer;
    }

    private void writeEscapedString(String string, StringBuilder builder) {
        builder.append(StringEscapeUtils.escapeJava((String)string));
    }

    private Optional<BigDecimal> getBigDecimal(String decimalString) {
        try {
            return Optional.of(new BigDecimal(decimalString));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

