/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.decompress;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.plugins.processor.decompress.DecompressionEngineFactory;
import org.opensearch.dataprepper.plugins.processor.decompress.DecompressionType;
import org.opensearch.dataprepper.plugins.processor.decompress.encoding.DecoderEngineFactory;
import org.opensearch.dataprepper.plugins.processor.decompress.encoding.EncodingType;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>decompress</code> processor decompresses any Base64-encoded compressed fields inside of an event.")
public class DecompressProcessorConfig {
    @JsonPropertyDescription(value="The keys in the event that will be decompressed.")
    @JsonProperty(value="keys")
    @NotEmpty
    @NotNull
    private List<String> keys;
    @JsonPropertyDescription(value="The type of decompression to use for the keys in the event. Only <code>gzip</code> is supported.")
    @JsonProperty(value="type")
    @NotNull
    @ExampleValues(value={@ExampleValues.Example(value="gzip", description="GZIP decompression.")})
    private DecompressionType decompressionType;
    @JsonPropertyDescription(value="A list of strings with which to tag events when the processor fails to decompress the keys inside an event. Defaults to <code>_decompression_failure</code>.")
    @JsonProperty(value="tags_on_failure")
    private List<String> tagsOnFailure = List.of("_decompression_failure");
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a>, such as <code>/is_compressed == true</code>, that determines when the decompress processor will run on certain events.")
    @JsonProperty(value="decompress_when")
    @ExampleValues(value={@ExampleValues.Example(value="/some_key == null", description="Only runs the decompress processor on the Event if the key some_key is null or does not exist.")})
    private String decompressWhen;
    @JsonIgnore
    private final EncodingType encodingType = EncodingType.BASE64;

    public List<String> getKeys() {
        return this.keys;
    }

    public DecompressionEngineFactory getDecompressionType() {
        return this.decompressionType;
    }

    public DecoderEngineFactory getEncodingType() {
        return this.encodingType;
    }

    public String getDecompressWhen() {
        return this.decompressWhen;
    }

    public List<String> getTagsOnFailure() {
        return this.tagsOnFailure;
    }
}

