/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate;

import com.google.common.collect.Maps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.plugins.hasher.IdentificationKeysHasher;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateGroup;

class AggregateGroupManager {
    private final Map<IdentificationKeysHasher.IdentificationKeysMap, AggregateGroup> allGroups = Maps.newConcurrentMap();
    private final Duration groupDuration;
    private final boolean acknowledgeOnConclude;

    AggregateGroupManager(Duration groupDuration, boolean acknowledgeOnConclude) {
        this.groupDuration = groupDuration;
        this.acknowledgeOnConclude = acknowledgeOnConclude;
    }

    AggregateGroup getAggregateGroup(IdentificationKeysHasher.IdentificationKeysMap identificationKeysMap) {
        return this.allGroups.computeIfAbsent(identificationKeysMap, hash -> new AggregateGroup(identificationKeysMap.getKeyMap()));
    }

    List<Map.Entry<IdentificationKeysHasher.IdentificationKeysMap, AggregateGroup>> getGroupsToConclude(boolean forceConclude) {
        ArrayList<Map.Entry<IdentificationKeysHasher.IdentificationKeysMap, AggregateGroup>> groupsToConclude = new ArrayList<Map.Entry<IdentificationKeysHasher.IdentificationKeysMap, AggregateGroup>>();
        for (Map.Entry<IdentificationKeysHasher.IdentificationKeysMap, AggregateGroup> groupEntry : this.allGroups.entrySet()) {
            if (!groupEntry.getValue().shouldConcludeGroup(this.groupDuration) && !forceConclude) continue;
            groupsToConclude.add(groupEntry);
        }
        return groupsToConclude;
    }

    void closeGroup(IdentificationKeysHasher.IdentificationKeysMap hashKeyMap, AggregateGroup group) {
        EventHandle handle;
        this.allGroups.remove(hashKeyMap, group);
        if (this.acknowledgeOnConclude && (handle = group.getEventHandle()) != null) {
            handle.release(true);
        }
        group.resetGroup();
    }

    void putGroupWithHash(IdentificationKeysHasher.IdentificationKeysMap hashKeyMap, AggregateGroup group) {
        this.allGroups.put(hashKeyMap, group);
    }

    long getAllGroupsSize() {
        return this.allGroups.size();
    }

    Duration getGroupDuration() {
        return this.groupDuration;
    }
}

