/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.aggregate;

import io.micrometer.core.instrument.Counter;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.hasher.IdentificationKeysHasher;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateAction;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionOutput;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateActionResponse;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateGroup;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateGroupManager;
import org.opensearch.dataprepper.plugins.processor.aggregate.AggregateProcessorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AggregateActionSynchronizer {
    static final String ACTION_HANDLE_EVENTS_PROCESSING_ERRORS = "actionHandleEventsProcessingErrors";
    static final String ACTION_CONCLUDE_GROUP_EVENTS_PROCESSING_ERRORS = "actionConcludeGroupProcessingErrors";
    private final Counter actionHandleEventsProcessingErrors;
    private final Counter actionConcludeGroupEventsProcessingErrors;
    private final AggregateAction aggregateAction;
    private final AggregateGroupManager aggregateGroupManager;
    private final boolean disableGroupAcknowledgments;
    private static final Logger LOG = LoggerFactory.getLogger(AggregateActionSynchronizer.class);

    private AggregateActionSynchronizer(AggregateAction aggregateAction, AggregateGroupManager aggregateGroupManager, PluginMetrics pluginMetrics, AggregateProcessorConfig aggregateProcessorConfig) {
        this.aggregateAction = aggregateAction;
        this.aggregateGroupManager = aggregateGroupManager;
        this.disableGroupAcknowledgments = aggregateProcessorConfig.getDisableGroupAcknowledgments();
        this.actionHandleEventsProcessingErrors = pluginMetrics.counter(ACTION_HANDLE_EVENTS_PROCESSING_ERRORS);
        this.actionConcludeGroupEventsProcessingErrors = pluginMetrics.counter(ACTION_CONCLUDE_GROUP_EVENTS_PROCESSING_ERRORS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AggregateActionOutput concludeGroup(IdentificationKeysHasher.IdentificationKeysMap hash, AggregateGroup aggregateGroup, boolean forceConclude) {
        Lock concludeGroupLock = aggregateGroup.getConcludeGroupLock();
        Lock handleEventForGroupLock = aggregateGroup.getHandleEventForGroupLock();
        AggregateActionOutput actionOutput = new AggregateActionOutput(Collections.emptyList());
        if (concludeGroupLock.tryLock()) {
            handleEventForGroupLock.lock();
            try {
                if (aggregateGroup.shouldConcludeGroup(this.aggregateGroupManager.getGroupDuration()) || forceConclude) {
                    LOG.debug("Start critical section in concludeGroup");
                    actionOutput = this.aggregateAction.concludeGroup(aggregateGroup);
                    this.aggregateGroupManager.closeGroup(hash, aggregateGroup);
                }
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.NOISY, "Error while concluding group: ", (Throwable)e);
                this.actionConcludeGroupEventsProcessingErrors.increment();
            }
            finally {
                handleEventForGroupLock.unlock();
                concludeGroupLock.unlock();
            }
        }
        return actionOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AggregateActionResponse handleEventForGroup(Event event, IdentificationKeysHasher.IdentificationKeysMap hash, AggregateGroup aggregateGroup) {
        AggregateActionResponse handleEventResponse;
        Lock concludeGroupLock = aggregateGroup.getConcludeGroupLock();
        Lock handleEventForGroupLock = aggregateGroup.getHandleEventForGroupLock();
        concludeGroupLock.lock();
        concludeGroupLock.unlock();
        handleEventForGroupLock.lock();
        try {
            LOG.debug("Start critical section in handleEventForGroup");
            if (!this.disableGroupAcknowledgments) {
                aggregateGroup.attachToEventAcknowledgementSet(event);
            }
            handleEventResponse = this.aggregateAction.handleEvent(event, aggregateGroup);
            this.aggregateGroupManager.putGroupWithHash(hash, aggregateGroup);
        }
        catch (Exception e) {
            LOG.error(DataPrepperMarkers.NOISY, "Error while handling event, event will be processed by remainder of the pipeline: ", (Throwable)e);
            this.actionHandleEventsProcessingErrors.increment();
            handleEventResponse = new AggregateActionResponse(event);
        }
        finally {
            handleEventForGroupLock.unlock();
        }
        return handleEventResponse;
    }

    static class AggregateActionSynchronizerProvider {
        AggregateActionSynchronizerProvider() {
        }

        public AggregateActionSynchronizer provide(AggregateAction aggregateAction, AggregateGroupManager aggregateGroupManager, PluginMetrics pluginMetrics, AggregateProcessorConfig aggregateProcessorConfig) {
            return new AggregateActionSynchronizer(aggregateAction, aggregateGroupManager, pluginMetrics, aggregateProcessorConfig);
        }
    }
}

