/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.common.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ResponseHandling {
    RECONSTRUCT_DOCUMENT("reconstruct-document");

    private static final Map<String, ResponseHandling> NAMES_MAP;
    private final String optionName;

    private ResponseHandling(String optionName) {
        this.optionName = optionName;
    }

    @JsonValue
    public String getOptionName() {
        return this.optionName;
    }

    @JsonCreator
    public static ResponseHandling fromOptionName(String optionName) {
        return NAMES_MAP.get(optionName);
    }

    static {
        NAMES_MAP = Arrays.stream(ResponseHandling.values()).collect(Collectors.toMap(value -> value.optionName, value -> value));
    }
}

