/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.common.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.time.Duration;

public class ClientOptions {
    public static final int DEFAULT_CONNECTION_RETRIES = 3;
    public static final int DEFAULT_MAXIMUM_CONCURRENCY = 200;
    public static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    public static final Duration DEFAULT_API_TIMEOUT = Duration.ofSeconds(60L);
    public static final Duration DEFAULT_BASE_DELAY = Duration.ofMillis(100L);
    public static final Duration DEFAULT_MAX_BACKOFF = Duration.ofSeconds(20L);
    @JsonPropertyDescription(value="Total retries we want before failing")
    @JsonProperty(value="max_retries")
    private int maxConnectionRetries = 3;
    @JsonPropertyDescription(value="api call timeout defines the time sdk maintains the api call to complete before timing out")
    @JsonProperty(value="api_call_timeout")
    private Duration apiCallTimeout = DEFAULT_API_TIMEOUT;
    @JsonPropertyDescription(value="api call attempt timeout defines the time sdk waits for a single attempt before timing out")
    @JsonProperty(value="api_call_attempt_timeout")
    private Duration apiCallAttemptTimeout;
    @JsonPropertyDescription(value="sdk timeout defines the time sdk maintains the connection to the client before timing out")
    @JsonProperty(value="connection_timeout")
    private Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    @JsonPropertyDescription(value="read timeout defines the time sdk waits for data to be read from an established connection")
    @JsonProperty(value="read_timeout")
    private Duration readTimeout;
    @JsonPropertyDescription(value="max concurrency defined from the client side")
    @JsonProperty(value="max_concurrency")
    private int maxConcurrency = 200;
    @JsonPropertyDescription(value="Base delay for exponential backoff")
    @JsonProperty(value="base_delay")
    private Duration baseDelay = DEFAULT_BASE_DELAY;
    @JsonPropertyDescription(value="Maximum backoff time for exponential backoff")
    @JsonProperty(value="max_backoff")
    private Duration maxBackoff = DEFAULT_MAX_BACKOFF;

    public int getMaxConnectionRetries() {
        return this.maxConnectionRetries;
    }

    public Duration getApiCallTimeout() {
        return this.apiCallTimeout;
    }

    public Duration getApiCallAttemptTimeout() {
        return this.apiCallAttemptTimeout;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public int getMaxConcurrency() {
        return this.maxConcurrency;
    }

    public Duration getBaseDelay() {
        return this.baseDelay;
    }

    public Duration getMaxBackoff() {
        return this.maxBackoff;
    }
}

