/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.metric;

import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.metric.Bucket;
import org.opensearch.dataprepper.model.metric.DefaultBucket;
import org.opensearch.dataprepper.model.metric.Histogram;
import org.opensearch.dataprepper.model.metric.JacksonMetric;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.validation.ParameterValidator;

public class JacksonHistogram
extends JacksonMetric
implements Histogram {
    private static final String SUM_KEY = "sum";
    private static final String MAX_KEY = "max";
    private static final String MIN_KEY = "min";
    private static final String COUNT_KEY = "count";
    private static final String AGGREGATION_TEMPORALITY_KEY = "aggregationTemporality";
    private static final String BUCKET_COUNTS_KEY = "bucketCounts";
    private static final String EXPLICIT_BOUNDS_COUNT_KEY = "explicitBoundsCount";
    public static final String BUCKETS_KEY = "buckets";
    private static final String BUCKET_COUNTS_LIST_KEY = "bucketCountsList";
    private static final String EXPLICIT_BOUNDS_KEY = "explicitBounds";
    private static final List<String> REQUIRED_KEYS = new ArrayList<String>();
    private static final List<String> REQUIRED_NON_EMPTY_KEYS = Arrays.asList("name", "kind", "time");
    private static final List<String> REQUIRED_NON_NULL_KEYS = Collections.singletonList("sum");

    protected JacksonHistogram(Builder builder, boolean flattenAttributes) {
        super(builder, flattenAttributes);
        this.checkAndSetDefaultValues();
        new ParameterValidator().validate(REQUIRED_KEYS, REQUIRED_NON_EMPTY_KEYS, REQUIRED_NON_NULL_KEYS, (HashMap)this.toMap());
        Preconditions.checkArgument((boolean)this.getMetadata().getEventType().equals(EventType.METRIC.toString()), (Object)"eventType must be of type Metric");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Double getSum() {
        return this.get(SUM_KEY, Double.class);
    }

    @Override
    public Double getMin() {
        return this.get(MIN_KEY, Double.class);
    }

    @Override
    public Double getMax() {
        return this.get(MAX_KEY, Double.class);
    }

    @Override
    public Long getCount() {
        return this.get(COUNT_KEY, Long.class);
    }

    @Override
    public String getAggregationTemporality() {
        return this.get(AGGREGATION_TEMPORALITY_KEY, String.class);
    }

    @Override
    public Integer getBucketCount() {
        return this.get(BUCKET_COUNTS_KEY, Integer.class);
    }

    @Override
    public Integer getExplicitBoundsCount() {
        return this.get(EXPLICIT_BOUNDS_COUNT_KEY, Integer.class);
    }

    @Override
    public List<? extends Bucket> getBuckets() {
        return this.getList(BUCKETS_KEY, DefaultBucket.class);
    }

    @Override
    public List<Long> getBucketCountsList() {
        return this.getList(BUCKET_COUNTS_LIST_KEY, Long.class);
    }

    @Override
    public List<Double> getExplicitBoundsList() {
        return this.getList(EXPLICIT_BOUNDS_KEY, Double.class);
    }

    public static class Builder
    extends JacksonMetric.Builder<Builder> {
        @Override
        public Builder getThis() {
            return this;
        }

        public Builder withSum(double sum) {
            this.put(JacksonHistogram.SUM_KEY, sum);
            return this;
        }

        public Builder withMin(Double min) {
            if (min != null) {
                this.put(JacksonHistogram.MIN_KEY, min);
            }
            return this;
        }

        public Builder withMax(Double max) {
            if (max != null) {
                this.put(JacksonHistogram.MAX_KEY, max);
            }
            return this;
        }

        public Builder withCount(long count) {
            this.put(JacksonHistogram.COUNT_KEY, count);
            return this;
        }

        public Builder withBucketCount(int bucketCount) {
            this.put(JacksonHistogram.BUCKET_COUNTS_KEY, bucketCount);
            return this;
        }

        public Builder withExplicitBoundsCount(int explicitBoundsCount) {
            this.put(JacksonHistogram.EXPLICIT_BOUNDS_COUNT_KEY, explicitBoundsCount);
            return this;
        }

        public Builder withAggregationTemporality(String aggregationTemporality) {
            this.put(JacksonHistogram.AGGREGATION_TEMPORALITY_KEY, aggregationTemporality);
            return this;
        }

        @Override
        public Builder withTimeReceived(Instant timeReceived) {
            return (Builder)super.withTimeReceived(timeReceived);
        }

        public Builder withBuckets(List<Bucket> buckets) {
            this.put(JacksonHistogram.BUCKETS_KEY, buckets);
            return this;
        }

        public Builder withBucketCountsList(List<Long> bucketCountsList) {
            this.put(JacksonHistogram.BUCKET_COUNTS_LIST_KEY, bucketCountsList);
            return this;
        }

        public Builder withExplicitBoundsList(List<Double> explicitBoundsList) {
            this.put(JacksonHistogram.EXPLICIT_BOUNDS_KEY, explicitBoundsList);
            return this;
        }

        @Override
        public JacksonHistogram build() {
            return this.build(true);
        }

        public JacksonHistogram build(boolean flattenAttributes) {
            this.populateEvent(Metric.KIND.HISTOGRAM.toString());
            return new JacksonHistogram(this, flattenAttributes);
        }
    }
}

