/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.failures;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlqObject {
    private static final Logger LOG = LoggerFactory.getLogger(DlqObject.class);
    private static final String ISO8601_FORMAT_STRING = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").withZone(ZoneId.systemDefault());
    private final String pluginId;
    private final String pluginName;
    private final String pipelineName;
    private final Object failedData;
    private final String timestamp;
    @JsonIgnore
    private final Event event;
    @JsonIgnore
    private final List<EventHandle> eventHandles;

    private DlqObject(String pluginId, String pluginName, String pipelineName, String timestamp, Object failedData, List<EventHandle> eventHandles, Event event) {
        Preconditions.checkNotNull((Object)pluginId, (Object)"pluginId cannot be null");
        Preconditions.checkArgument((!pluginId.isEmpty() ? 1 : 0) != 0, (Object)"pluginId cannot be an empty string");
        Preconditions.checkNotNull((Object)pluginName, (Object)"pluginName cannot be null");
        Preconditions.checkArgument((!pluginName.isEmpty() ? 1 : 0) != 0, (Object)"pluginName cannot be an empty string");
        Preconditions.checkNotNull((Object)pipelineName, (Object)"pipelineName cannot be null");
        Preconditions.checkArgument((!pipelineName.isEmpty() ? 1 : 0) != 0, (Object)"pipelineName cannot be an empty string");
        Preconditions.checkNotNull((Object)failedData, (Object)"failedData cannot be null");
        Preconditions.checkArgument((eventHandles == null || event == null ? 1 : 0) != 0, (Object)"Only one of eventhandles and event should be non-null");
        this.pluginId = pluginId;
        this.pluginName = pluginName;
        this.pipelineName = pipelineName;
        this.failedData = failedData;
        this.eventHandles = eventHandles;
        this.event = event;
        this.timestamp = StringUtils.isEmpty((CharSequence)timestamp) ? FORMATTER.format(Instant.now()) : timestamp;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public Object getFailedData() {
        return this.failedData;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Event getEvent() {
        return this.event;
    }

    public List<EventHandle> getEventHandles() {
        return this.eventHandles;
    }

    public void releaseEventHandle(boolean result) {
        if (this.event != null) {
            LOG.warn(DataPrepperMarkers.NOISY, "Attempted to release DLQObject with event");
        } else if (this.eventHandles != null && this.eventHandles.size() == 1) {
            this.eventHandles.get(0).release(result);
        }
    }

    public void releaseEventHandles(boolean result) {
        if (this.eventHandles == null) {
            if (this.event != null) {
                LOG.warn(DataPrepperMarkers.NOISY, "Attempted to release DLQObject with event");
            }
            return;
        }
        for (EventHandle eventHandle : this.eventHandles) {
            eventHandle.release(result);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DlqObject that = (DlqObject)o;
        return Objects.equals(this.failedData, that.getFailedData()) && Objects.equals(this.pluginId, that.pluginId) && Objects.equals(this.pluginName, that.pluginName) && Objects.equals(this.pipelineName, that.pipelineName) && Objects.equals(this.eventHandles, that.eventHandles) && Objects.equals(this.event, that.event) && Objects.equals(this.timestamp, that.getTimestamp());
    }

    public int hashCode() {
        return Objects.hash(this.pluginId, this.pluginName, this.pipelineName, this.timestamp, this.failedData);
    }

    public String toString() {
        return "DlqObject{pluginId='" + this.pluginId + "', pluginName='" + this.pluginName + "', pipelineName='" + this.pipelineName + "', timestamp='" + this.timestamp + "', failedData=" + String.valueOf(this.failedData) + "}";
    }

    public static DlqObject createDlqObject(PluginSetting pluginSetting, List<EventHandle> eventHandles, Object failedData) {
        return DlqObject.builder().withEventHandles(eventHandles).withEvent(null).withFailedData(failedData).withPluginName(pluginSetting.getName()).withPipelineName(pluginSetting.getPipelineName()).withPluginId(pluginSetting.getName()).build();
    }

    public static DlqObject createDlqObject(PluginSetting pluginSetting, Event event, Object failedData) {
        return DlqObject.builder().withEventHandles(null).withEvent(event).withFailedData(failedData).withPluginName(pluginSetting.getName()).withPipelineName(pluginSetting.getPipelineName()).withPluginId(pluginSetting.getName()).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String pluginId;
        private String pluginName;
        private String pipelineName;
        private Object failedData;
        private List<EventHandle> eventHandles;
        private Event event;
        private String timestamp;

        public Builder withPluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public Builder withPluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public Builder withPipelineName(String pipelineName) {
            this.pipelineName = pipelineName;
            return this;
        }

        public Builder withFailedData(Object failedData) {
            this.failedData = failedData;
            return this;
        }

        public Builder withTimestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder withEventHandles(List<EventHandle> eventHandles) {
            this.eventHandles = eventHandles;
            return this;
        }

        public Builder withEvent(Event event) {
            this.event = event;
            return this;
        }

        public Builder withEventHandle(EventHandle eventHandle) {
            this.eventHandles = new ArrayList<EventHandle>();
            this.eventHandles.add(eventHandle);
            return this;
        }

        public Builder withTimestamp(Instant instant) {
            this.timestamp = FORMATTER.format(instant);
            return this;
        }

        public DlqObject build() {
            return new DlqObject(this.pluginId, this.pluginName, this.pipelineName, this.timestamp, this.failedData, this.eventHandles, this.event);
        }
    }
}

