/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.model.configuration;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opensearch.dataprepper.model.configuration.ConditionalRoute;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.SinkModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineModel {
    public static final String SOURCE_PLUGIN_TYPE = "source";
    public static final String PROCESSOR_PLUGIN_TYPE = "processor";
    public static final String BUFFER_PLUGIN_TYPE = "buffer";
    public static final String ROUTE_PLUGIN_TYPE = "route";
    public static final String SINK_PLUGIN_TYPE = "sink";
    private static final Logger LOG = LoggerFactory.getLogger(PipelineModel.class);
    @JsonProperty(value="source")
    private final PluginModel source;
    @JsonProperty(value="processor")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final List<PluginModel> processors;
    @JsonProperty(value="buffer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final PluginModel buffer;
    @JsonProperty(value="routes")
    @JsonAlias(value={"route"})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final List<ConditionalRoute> routes;
    @JsonProperty(value="sink")
    private final List<SinkModel> sinks;
    @JsonProperty(value="workers")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Integer workers;
    @JsonProperty(value="delay")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final Integer readBatchDelay;

    @JsonCreator
    public PipelineModel(@JsonProperty(value="source") PluginModel source, @JsonProperty(value="buffer") PluginModel buffer, @JsonProperty(value="processor") List<PluginModel> processors, @JsonProperty(value="routes") @JsonAlias(value={"route"}) List<ConditionalRoute> routes, @JsonProperty(value="sink") List<SinkModel> sinks, @JsonProperty(value="workers") Integer workers, @JsonProperty(value="delay") Integer delay) {
        Preconditions.checkArgument((boolean)Objects.nonNull(sinks), (Object)"Sinks must not be null");
        Preconditions.checkArgument((sinks.size() > 0 ? 1 : 0) != 0, (Object)"PipelineModel must include at least 1 sink");
        this.source = source;
        this.buffer = buffer;
        this.processors = processors;
        this.routes = routes != null ? routes : new ArrayList();
        this.sinks = sinks;
        this.workers = workers;
        this.readBatchDelay = delay;
    }

    public PluginModel getSource() {
        return this.source;
    }

    public PluginModel getBuffer() {
        return this.buffer;
    }

    public List<PluginModel> getProcessors() {
        return this.processors;
    }

    public List<ConditionalRoute> getRoutes() {
        return this.routes;
    }

    public List<SinkModel> getSinks() {
        return this.sinks;
    }

    public Integer getWorkers() {
        return this.workers;
    }

    public Integer getReadBatchDelay() {
        return this.readBatchDelay;
    }
}

